package com.kingsoft.shiyou.omnisdk.api;

import android.app.Application;
import android.content.Context;

import androidx.multidex.MultiDex;

import com.netease.yofun.external.BaseApplication;

import com.kingsoft.shiyou.omnisdk.api.OmniSDK;

import org.jetbrains.annotations.NotNull;

/**
 * ### OmniApplication
 *
 * @since 1.0
 */
public class OmniApplication extends BaseApplication implements androidx.work.Configuration.Provider {

    @NotNull
    @Override
    public androidx.work.Configuration getWorkManagerConfiguration() {
        return new androidx.work.Configuration.Builder()
                .setMinimumLoggingLevel(android.util.Log.INFO)
                .build();
    }


    @Override
    public void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        OmniSDK.getInstance().onApplicationAttachBaseContext(base);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        OmniSDK.getInstance().onApplicationCreate(this);
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        OmniSDK.getInstance().onApplicationLowMemory();
    }

    @Override
    public void onTrimMemory(int level) {
        super.onTrimMemory(level);
        OmniSDK.getInstance().onApplicationTrimMemory();
    }

    @Override
    public void onTerminate() {
        super.onTerminate();
        OmniSDK.getInstance().onApplicationTerminate();
    }
}
