/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.writer;

import com.tencent.vasdolly.common.ApkSectionInfo;
import com.tencent.vasdolly.common.V2SchemeUtil;
import com.tencent.vasdolly.common.verify.ApkSignatureSchemeV2Verifier;
import com.tencent.vasdolly.common.verify.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IdValueWriter {
    public static void addIdValue(ApkSectionInfo apkSectionInfo, File destApk, int id, ByteBuffer valueBuffer) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (id == 1896449818) {
            throw new RuntimeException("addIdValue , id can not is " + String.valueOf(1896449818) + " , v2 signature block use it");
        }
        LinkedHashMap<Integer, ByteBuffer> idValueMap = new LinkedHashMap<Integer, ByteBuffer>();
        idValueMap.put(id, valueBuffer);
        IdValueWriter.addIdValueByteBufferMap(apkSectionInfo, destApk, idValueMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIdValue(ApkSectionInfo apkSectionInfo, File destApk, List<Integer> idList) throws ApkSignatureSchemeV2Verifier.SignatureNotFoundException, IOException {
        if (apkSectionInfo == null || destApk == null || !destApk.isFile() || !destApk.exists() || idList == null || idList.isEmpty()) {
            return;
        }
        Map existentIdValueMap = V2SchemeUtil.getAllIdValue((ByteBuffer)((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()));
        int existentIdValueSize = existentIdValueMap.size();
        if (!existentIdValueMap.containsKey(1896449818)) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("No APK V2 Signature Scheme block in APK Signing Block");
        }
        System.out.println("removeIdValue , existed IdValueMap = " + existentIdValueMap);
        for (Integer id : idList) {
            if (id == 1896449818) continue;
            existentIdValueMap.remove(id);
        }
        int remainderIdValueSize = existentIdValueMap.size();
        if (existentIdValueSize == remainderIdValueSize) {
            System.out.println("removeIdValue , No idValue was deleted");
        } else {
            System.out.println("removeIdValue , final IdValueMap = " + existentIdValueMap);
            ByteBuffer newApkSigningBlock = V2SchemeUtil.generateApkSigningBlock((Map)existentIdValueMap);
            System.out.println("removeIdValue , oldApkSigningBlock size = " + ((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()).remaining() + " , newApkSigningBlock size = " + newApkSigningBlock.remaining());
            ByteBuffer centralDir = (ByteBuffer)apkSectionInfo.centralDir.getFirst();
            ByteBuffer eocd = (ByteBuffer)apkSectionInfo.eocd.getFirst();
            long centralDirOffset = (Long)apkSectionInfo.centralDir.getSecond();
            int apkChangeSize = newApkSigningBlock.remaining() - ((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()).remaining();
            ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)eocd, (long)(centralDirOffset + (long)apkChangeSize));
            long apkLength = apkSectionInfo.apkSize + (long)apkChangeSize;
            RandomAccessFile fIn = null;
            try {
                fIn = new RandomAccessFile(destApk, "rw");
                if (apkSectionInfo.lowMemory) {
                    fIn.seek((Long)apkSectionInfo.schemeV2Block.getSecond());
                } else {
                    ByteBuffer contentEntry = (ByteBuffer)apkSectionInfo.contentEntry.getFirst();
                    fIn.seek((Long)apkSectionInfo.contentEntry.getSecond());
                    fIn.write(contentEntry.array(), contentEntry.arrayOffset() + contentEntry.position(), contentEntry.remaining());
                }
                fIn.write(newApkSigningBlock.array(), newApkSigningBlock.arrayOffset() + newApkSigningBlock.position(), newApkSigningBlock.remaining());
                fIn.write(centralDir.array(), centralDir.arrayOffset() + centralDir.position(), centralDir.remaining());
                fIn.write(eocd.array(), eocd.arrayOffset() + eocd.position(), eocd.remaining());
                if (fIn.getFilePointer() != apkLength) {
                    throw new RuntimeException("after removeIdValue , file size wrong , FilePointer : " + fIn.getFilePointer() + ", apkLength : " + apkLength);
                }
                fIn.setLength(apkLength);
                System.out.println("removeIdValue , after remove channel , apk is " + destApk.getAbsolutePath() + " , length = " + destApk.length());
            }
            finally {
                ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)eocd, (long)centralDirOffset);
                if (fIn != null) {
                    fIn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIdValueByteBufferMap(ApkSectionInfo apkSectionInfo, File destApk, Map<Integer, ByteBuffer> idValueMap) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (idValueMap == null || idValueMap.isEmpty()) {
            throw new RuntimeException("addIdValueByteBufferMap , id value pair is empty");
        }
        if (idValueMap.containsKey(1896449818)) {
            idValueMap.remove(1896449818);
        }
        System.out.println("addIdValueByteBufferMap , new IdValueMap = " + idValueMap);
        Map existentIdValueMap = V2SchemeUtil.getAllIdValue((ByteBuffer)((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()));
        if (!existentIdValueMap.containsKey(1896449818)) {
            throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("No APK V2 Signature Scheme block in APK Signing Block");
        }
        System.out.println("addIdValueByteBufferMap , existed IdValueMap = " + existentIdValueMap);
        existentIdValueMap.putAll(idValueMap);
        System.out.println("addIdValueByteBufferMap , final IdValueMap = " + existentIdValueMap);
        ByteBuffer newApkSigningBlock = V2SchemeUtil.generateApkSigningBlock((Map)existentIdValueMap);
        System.out.println("addIdValueByteBufferMap , oldApkSigningBlock size = " + ((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()).remaining() + " , newApkSigningBlock size = " + newApkSigningBlock.remaining());
        ByteBuffer centralDir = (ByteBuffer)apkSectionInfo.centralDir.getFirst();
        ByteBuffer eocd = (ByteBuffer)apkSectionInfo.eocd.getFirst();
        long centralDirOffset = (Long)apkSectionInfo.centralDir.getSecond();
        int apkChangeSize = newApkSigningBlock.remaining() - ((ByteBuffer)apkSectionInfo.schemeV2Block.getFirst()).remaining();
        ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)eocd, (long)(centralDirOffset + (long)apkChangeSize));
        long apkLength = apkSectionInfo.apkSize + (long)apkChangeSize;
        RandomAccessFile fIn = null;
        try {
            fIn = new RandomAccessFile(destApk, "rw");
            if (apkSectionInfo.lowMemory) {
                fIn.seek((Long)apkSectionInfo.schemeV2Block.getSecond());
            } else {
                ByteBuffer contentEntry = (ByteBuffer)apkSectionInfo.contentEntry.getFirst();
                fIn.seek((Long)apkSectionInfo.contentEntry.getSecond());
                fIn.write(contentEntry.array(), contentEntry.arrayOffset() + contentEntry.position(), contentEntry.remaining());
            }
            fIn.write(newApkSigningBlock.array(), newApkSigningBlock.arrayOffset() + newApkSigningBlock.position(), newApkSigningBlock.remaining());
            fIn.write(centralDir.array(), centralDir.arrayOffset() + centralDir.position(), centralDir.remaining());
            fIn.write(eocd.array(), eocd.arrayOffset() + eocd.position(), eocd.remaining());
            if (fIn.getFilePointer() != apkLength) {
                throw new RuntimeException("after addIdValueByteBufferMap , file size wrong , FilePointer : " + fIn.getFilePointer() + ", apkLength : " + apkLength);
            }
            fIn.setLength(apkLength);
            System.out.println("addIdValueByteBufferMap , after add channel , new apk is " + destApk.getAbsolutePath() + " , length = " + destApk.length());
        }
        finally {
            ZipUtils.setZipEocdCentralDirectoryOffset((ByteBuffer)eocd, (long)centralDirOffset);
            if (fIn != null) {
                fIn.close();
            }
        }
    }

    public static void addIdValue(File srcApk, File destApk, int id, byte[] buffer, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        ApkSectionInfo apkSectionInfo = IdValueWriter.getApkSectionInfo(srcApk, lowMemory);
        ByteBuffer channelByteBuffer = ByteBuffer.wrap(buffer);
        channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IdValueWriter.addIdValue(apkSectionInfo, destApk, id, channelByteBuffer);
    }

    public static void addIdValue(File apkFile, int id, byte[] buffer, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        IdValueWriter.addIdValue(apkFile, apkFile, id, buffer, lowMemory);
    }

    public static void addIdValueByteMap(File srcApk, File destApk, Map<Integer, byte[]> idValueByteMap, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (idValueByteMap == null || idValueByteMap.isEmpty()) {
            throw new RuntimeException("addIdValueByteMap , idValueByteMap is empty");
        }
        ApkSectionInfo apkSectionInfo = IdValueWriter.getApkSectionInfo(srcApk, lowMemory);
        LinkedHashMap<Integer, ByteBuffer> idValues = new LinkedHashMap<Integer, ByteBuffer>();
        for (Integer integer : idValueByteMap.keySet()) {
            ByteBuffer channelByteBuffer = ByteBuffer.wrap(idValueByteMap.get(integer));
            channelByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            idValues.put(integer, channelByteBuffer);
        }
        IdValueWriter.addIdValueByteBufferMap(apkSectionInfo, destApk, idValues);
    }

    public static void addIdValueByteMap(File apkFile, Map<Integer, byte[]> idValueByteMap, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        IdValueWriter.addIdValueByteMap(apkFile, apkFile, idValueByteMap, lowMemory);
    }

    public static void removeIdValue(File apk, int id) {
    }

    public static ApkSectionInfo getApkSectionInfo(File baseApk, boolean lowMemory) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (baseApk == null || !baseApk.exists() || !baseApk.isFile()) {
            return null;
        }
        return V2SchemeUtil.getApkSectionInfo((File)baseApk, (boolean)lowMemory);
    }
}

