/*
 * Decompiled with CFR 0.152.
 */
package com.kingsoft.shiyou.omnisdk.ide.window;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.externalSystem.view.ExternalProjectTree;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.tree.TreeUtil;
import com.kingsoft.shiyou.omnisdk.build.entity.PlanChannel;
import com.kingsoft.shiyou.omnisdk.build.utils.LogUtils;
import com.kingsoft.shiyou.omnisdk.ide.ExtensionsKt;
import com.kingsoft.shiyou.omnisdk.ide.OmniMessages;
import com.kingsoft.shiyou.omnisdk.ide.action.AccountAction;
import com.kingsoft.shiyou.omnisdk.ide.action.IntegrationGuideAction;
import com.kingsoft.shiyou.omnisdk.ide.action.SingleCpsAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.ApiAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.BuildGuideAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.CodeAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.HelpAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.OmniSDKGuideAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.PluginGuideAction;
import com.kingsoft.shiyou.omnisdk.ide.action.docs.VersionAction;
import com.kingsoft.shiyou.omnisdk.ide.action.tool.GradleShowTaskUIAction;
import com.kingsoft.shiyou.omnisdk.ide.action.tool.GradleSyncAction;
import com.kingsoft.shiyou.omnisdk.ide.action.tool.ToolsAction;
import com.kingsoft.shiyou.omnisdk.ide.utils.GradleCommandUtils;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u00108\u001a\u0002092\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010:\u001a\u000209H\u0002J\b\u0010;\u001a\u00020<H\u0002J\u001a\u0010=\u001a\u0002042\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010>\u001a\u00020?H\u0002J\u0006\u0010@\u001a\u000204J\u0018\u0010A\u001a\u0002042\u0006\u0010B\u001a\u00020\u00062\u0006\u0010C\u001a\u00020?H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001e\u0010\"\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020&@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006D"}, d2={"Lcom/kingsoft/shiyou/omnisdk/ide/window/OmniToolWindow;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allDebugLabel", "", "allReleaseLabel", "buildMap", "", "channelList", "", "Lcom/kingsoft/shiyou/omnisdk/build/entity/PlanChannel;", "getChannelList", "()Ljava/util/List;", "cmdOmniBuild", "<set-?>", "Ljavax/swing/Box;", "contentBox", "getContentBox", "()Ljavax/swing/Box;", "extensionBuildChannels", "extensionBuildTarget", "extensionBuildType", "extensionDebugMode", "multiChannelsLabel", "omniSyncChannelPlan", "planId", "getPlanId", "()Ljava/lang/String;", "prefix", "getProject", "()Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "rootContent", "getRootContent", "()Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "rootLabel", "Lcom/intellij/ui/components/JBScrollPane;", "scrollPane", "getScrollPane", "()Lcom/intellij/ui/components/JBScrollPane;", "singleDebugLabel", "singleReleaseLabel", "tag", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "getTree", "()Lcom/intellij/ui/treeStructure/SimpleTree;", "setTree", "(Lcom/intellij/ui/treeStructure/SimpleTree;)V", "addBuildTaskNode", "", "treeNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "addChannelTaskNode", "createToolbar", "Ljavax/swing/JComponent;", "toolbarTarget", "createTreeNode", "Ljavax/swing/tree/DefaultTreeModel;", "loadView", "isInited", "", "refreshTree", "runCommand", "commandArgs", "isUpdatePlan", "IDEPlugin"})
public final class OmniToolWindow {
    @NotNull
    private final Project project;
    @NotNull
    private final String tag;
    @NotNull
    private final String prefix;
    @NotNull
    private final String extensionBuildType;
    @NotNull
    private final String extensionBuildTarget;
    @NotNull
    private final String extensionDebugMode;
    @NotNull
    private final String extensionBuildChannels;
    @NotNull
    private final String cmdOmniBuild;
    @NotNull
    private final String omniSyncChannelPlan;
    @NotNull
    private final String rootLabel;
    @NotNull
    private final String allReleaseLabel;
    @NotNull
    private final String allDebugLabel;
    @NotNull
    private final String multiChannelsLabel;
    @NotNull
    private final String singleReleaseLabel;
    @NotNull
    private final String singleDebugLabel;
    @NotNull
    private final Map<String, String> buildMap;
    @NotNull
    private SimpleTree tree;
    @NotNull
    private SimpleToolWindowPanel rootContent;
    @NotNull
    private Box contentBox;
    @NotNull
    private JBScrollPane scrollPane;

    public OmniToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tag = "OmniToolWindow#";
        this.prefix = "build";
        this.extensionBuildType = "setBuildType";
        this.extensionBuildTarget = "setBuildTarget";
        this.extensionDebugMode = "isDebugMode";
        this.extensionBuildChannels = "setBuildChannels";
        this.cmdOmniBuild = "omniChannelsBuild";
        this.omniSyncChannelPlan = "omniSyncChannelPlan";
        this.rootLabel = "Channels Tree";
        this.allReleaseLabel = "All Channels Release";
        this.allDebugLabel = "All Channels Debug";
        this.multiChannelsLabel = "Multi-Channels Build";
        this.singleReleaseLabel = "Single Channel Release";
        this.singleDebugLabel = "Single Channel Debug";
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"apk", (Object)("-P" + this.extensionBuildType + "=assemble")), TuplesKt.to((Object)"aab", (Object)("-P" + this.extensionBuildType + "=bundle")), TuplesKt.to((Object)"apk&aab", (Object)("-P" + this.extensionBuildType + "=assemble,bundle"))};
        this.buildMap = MapsKt.mapOf((Pair[])pairArray);
        this.rootContent = new SimpleToolWindowPanel(true);
        this.tree = (SimpleTree)new ExternalProjectTree(this.project);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (treeSelectionModel != null) {
            treeSelectionModel.setSelectionMode(4);
        }
        this.tree.setModel((TreeModel)this.createTreeNode());
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        String id = ((CharSequence)this.getPlanId()).length() == 0 ? "(\u8bf7\u5148\u4e0b\u8f7d\u53d1\u5e03\u8ba1\u5212)" : "(planId:" + this.getPlanId() + ')';
        final JBCheckBox planUpdateBox = new JBCheckBox("\u7f16\u8bd1\u524d\u81ea\u52a8\u66f4\u65b0\u5f53\u524d\u53d1\u5e03\u8ba1\u5212\u5185\u5bb9" + id);
        planUpdateBox.setSelected(true);
        final JBCheckBox debugModeBox = new JBCheckBox("OmniSDK \u65e5\u5fd7\u5f00\u5173(\u6b63\u5f0f\u53d1\u5e03\u8bb0\u5f97\u5173\u95ed)");
        final JBCheckBox refreshBox = new JBCheckBox("\u5f3a\u5236\u5237\u65b0\u4f9d\u8d56 ");
        Box verticalBoxGroup = Box.createVerticalBox();
        Box horizontalBoxGroup1 = Box.createHorizontalBox();
        horizontalBoxGroup1.add((Component)debugModeBox);
        horizontalBoxGroup1.add(Box.createHorizontalGlue());
        horizontalBoxGroup1.add((Component)refreshBox);
        Box horizontalBoxGroup2 = Box.createHorizontalBox();
        horizontalBoxGroup2.add((Component)planUpdateBox);
        horizontalBoxGroup2.add(Box.createHorizontalGlue());
        verticalBoxGroup.add(horizontalBoxGroup1);
        verticalBoxGroup.add(horizontalBoxGroup2);
        this.scrollPane = new JBScrollPane((Component)this.tree);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                TreePath selPath;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseClicked(e);
                if (e.getSource() == this.getTree() && e.getClickCount() == 2 && (selPath = this.getTree().getPathForLocation(e.getX(), e.getY())) != null) {
                    String string = selPath.getLastPathComponent().toString().toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
                    String componentName = string;
                    LogUtils.d((String)tag, (String)("Double Click: " + componentName));
                    if (StringsKt.contains$default((CharSequence)componentName, (CharSequence)prefix, (boolean)false, (int)2, null)) {
                        LogUtils.d((String)tag, (String)("Double Click done: " + componentName));
                        String channel = selPath.getParentPath().getLastPathComponent().toString();
                        Object v = buildMap.get(StringsKt.replace$default((String)componentName, (String)(prefix + ' '), (String)"", (boolean)false, (int)4, null));
                        Intrinsics.checkNotNull(v);
                        String buildType = (String)v;
                        LogUtils.d((String)tag, (String)("Double Click done-channel: " + channel + ", " + buildType));
                        LogUtils.d((String)tag, (String)("Double Click debugModeBox: " + debugModeBox.isSelected() + ", refreshBox: " + refreshBox.isSelected()));
                        String refresh = refreshBox.isSelected() ? "--refresh-dependencies" : "";
                        String cmd = "-P" + extensionDebugMode + '=' + debugModeBox.isSelected() + ' ' + buildType + ' ' + refresh;
                        String string2 = channel;
                        if (!Intrinsics.areEqual((Object)string2, (Object)rootLabel)) {
                            if (Intrinsics.areEqual((Object)string2, (Object)allReleaseLabel)) {
                                cmd = cmd + " -P" + extensionBuildTarget + "=release";
                                this.runCommand(cmd, planUpdateBox.isSelected());
                            } else if (Intrinsics.areEqual((Object)string2, (Object)allDebugLabel)) {
                                cmd = cmd + " -P" + extensionBuildTarget + "=debug";
                                this.runCommand(cmd, planUpdateBox.isSelected());
                            } else {
                                String string3 = selPath.getParentPath().getParentPath().getLastPathComponent().toString();
                                OmniToolWindow omniToolWindow = this;
                                String $this$mouseClicked_u24lambda_u2d0 = string3;
                                boolean bl = false;
                                String target = Intrinsics.areEqual((Object)$this$mouseClicked_u24lambda_u2d0, (Object)omniToolWindow.singleDebugLabel) ? " -P" + omniToolWindow.extensionBuildTarget + "=debug" : " -P" + omniToolWindow.extensionBuildTarget + "=release";
                                cmd = cmd + ' ' + target + " -P" + extensionBuildChannels + '=' + channel;
                                this.runCommand(cmd, planUpdateBox.isSelected());
                            }
                        }
                    }
                }
            }
        });
        Box box = Box.createVerticalBox();
        Intrinsics.checkNotNullExpressionValue((Object)box, (String)"createVerticalBox()");
        this.contentBox = box;
        this.contentBox.add(verticalBoxGroup);
        this.contentBox.add((Component)this.scrollPane);
        this.loadView(this.project, true);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void runCommand(String commandArgs, boolean isUpdatePlan) {
        LogUtils.d((String)this.tag, (String)("runCommand command: " + commandArgs + ", isUpdatePlan: " + isUpdatePlan));
        String cmd = isUpdatePlan ? commandArgs + ' ' + this.omniSyncChannelPlan + ' ' + this.cmdOmniBuild : commandArgs + ' ' + this.cmdOmniBuild;
        GradleCommandUtils.INSTANCE.runGradle(this.project, cmd);
    }

    private final List<PlanChannel> getChannelList() {
        List list;
        try {
            String json = ExtensionsKt.getPlanChannels(this.project);
            LogUtils.d((String)this.tag, (String)("channelList: " + json));
            String $this$fromJson$iv = json;
            boolean $i$f$fromJson = false;
            Iterable $this$sortedBy$iv = (Iterable)new Gson().fromJson($this$fromJson$iv, new TypeToken<List<? extends PlanChannel>>(){}.getType());
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PlanChannel it = (PlanChannel)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getChannelName());
                    it = (PlanChannel)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getChannelName())));
                }
            });
        }
        catch (Exception e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final String getPlanId() {
        String string;
        try {
            String id = ExtensionsKt.getPlanId(this.project);
            LogUtils.d((String)this.tag, (String)("getPlanId: " + id));
        }
        catch (Exception e) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final SimpleTree getTree() {
        return this.tree;
    }

    public final void setTree(@NotNull SimpleTree simpleTree) {
        Intrinsics.checkNotNullParameter((Object)simpleTree, (String)"<set-?>");
        this.tree = simpleTree;
    }

    @NotNull
    public final SimpleToolWindowPanel getRootContent() {
        return this.rootContent;
    }

    @NotNull
    public final Box getContentBox() {
        return this.contentBox;
    }

    @NotNull
    public final JBScrollPane getScrollPane() {
        return this.scrollPane;
    }

    private final void loadView(Project project, boolean isInited) {
        if (!isInited) {
            this.rootContent.removeAll();
        }
        this.rootContent.setToolbar(this.createToolbar(project, (JComponent)this.rootContent));
        this.rootContent.setContent((JComponent)this.contentBox);
    }

    static /* synthetic */ void loadView$default(OmniToolWindow omniToolWindow, Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        omniToolWindow.loadView(project, bl);
    }

    public final void refreshTree() {
        this.tree.setModel((TreeModel)this.createTreeNode());
    }

    private final JComponent createToolbar(Project project, JComponent toolbarTarget) {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.add((AnAction)new GradleShowTaskUIAction());
        toolbarActions.add((AnAction)new GradleSyncAction());
        toolbarActions.addSeparator();
        Icon icon = AllIcons.Actions.Collapseall;
        toolbarActions.add((AnAction)new ToolsAction(this, icon){
            final /* synthetic */ OmniToolWindow this$0;
            {
                this.this$0 = $receiver;
                super("Collapseall", $super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreeUtil.collapseAll((JTree)((JTree)this.this$0.getTree()), (int)0);
            }
        });
        icon = AllIcons.Actions.Expandall;
        toolbarActions.add((AnAction)new ToolsAction(this, icon){
            final /* synthetic */ OmniToolWindow this$0;
            {
                this.this$0 = $receiver;
                super("Expandall", $super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TreeUtil.expandAll((JTree)((JTree)this.this$0.getTree()));
            }
        });
        toolbarActions.addSeparator();
        icon = AllIcons.Actions.Refresh;
        toolbarActions.add((AnAction)new ToolsAction(project, this, icon){
            final /* synthetic */ Project $project;
            final /* synthetic */ OmniToolWindow this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super("Refresh Channels Tree", $super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                OmniMessages.showInfo$default("Refresh", "Finish", this.$project, false, 8, null);
                this.this$0.refreshTree();
            }
        });
        toolbarActions.add((AnAction)new SingleCpsAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                e.getPresentation().setIcon(AllIcons.Nodes.Class);
            }
        });
        toolbarActions.add((AnAction)new IntegrationGuideAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                e.getPresentation().setIcon(AllIcons.Actions.CheckOut);
                e.getPresentation().setText("\u66f4\u65b0\u53d1\u5e03\u8ba1\u5212");
            }
        });
        toolbarActions.addSeparator();
        DefaultActionGroup docsActions = DefaultActionGroup.createPopupGroup(OmniToolWindow::createToolbar$lambda-1);
        docsActions.getTemplatePresentation().setIcon(AllIcons.Toolwindows.Documentation);
        docsActions.addSeparator();
        docsActions.add((AnAction)new BuildGuideAction());
        docsActions.addSeparator();
        docsActions.add((AnAction)new OmniSDKGuideAction());
        docsActions.add((AnAction)new ApiAction());
        docsActions.add((AnAction)new CodeAction());
        docsActions.addSeparator();
        docsActions.add((AnAction)new PluginGuideAction());
        docsActions.add((AnAction)new VersionAction());
        docsActions.add((AnAction)new HelpAction());
        DefaultActionGroup settingActions = DefaultActionGroup.createPopupGroup(OmniToolWindow::createToolbar$lambda-2);
        settingActions.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        AnAction[] anActionArray = new AnAction[]{new AccountAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                e.getPresentation().setIcon(AllIcons.CodeWithMe.Users);
            }
        }};
        settingActions.addAll(anActionArray);
        toolbarActions.add((AnAction)docsActions);
        toolbarActions.add((AnAction)settingActions);
        toolbarActions.addSeparator();
        toolbarActions.add((AnAction)new PluginGuideAction(){

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
                e.getPresentation().setIcon(StudioIcons.Common.HELP);
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("OmniSDK View Toolbar", (ActionGroup)toolbarActions, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"getInstance().createActi\u2026r\", toolbarActions, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(toolbarTarget);
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        JComponent toolbarComponent = jComponent;
        toolbarComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        return toolbarComponent;
    }

    private final DefaultTreeModel createTreeNode() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.rootLabel);
        DefaultMutableTreeNode allReleaseNode = new DefaultMutableTreeNode(this.allReleaseLabel);
        DefaultMutableTreeNode allDebugNode = new DefaultMutableTreeNode(this.allDebugLabel);
        DefaultMutableTreeNode singleReleaseNode = new DefaultMutableTreeNode(this.singleReleaseLabel);
        DefaultMutableTreeNode singleDebugNode = new DefaultMutableTreeNode(this.singleDebugLabel);
        rootNode.add(allReleaseNode);
        rootNode.add(allDebugNode);
        rootNode.add(singleReleaseNode);
        rootNode.add(singleDebugNode);
        this.addBuildTaskNode(allReleaseNode);
        this.addBuildTaskNode(allDebugNode);
        this.addChannelTaskNode(singleReleaseNode);
        this.addChannelTaskNode(singleDebugNode);
        return new DefaultTreeModel(rootNode);
    }

    private final void addChannelTaskNode(DefaultMutableTreeNode treeNode) {
        Iterable $this$forEach$iv = this.getChannelList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlanChannel it = (PlanChannel)element$iv;
            boolean bl = false;
            String channel = it.getChannelName();
            DefaultMutableTreeNode channelNode = new DefaultMutableTreeNode(channel);
            this.addBuildTaskNode(channelNode);
            treeNode.add(channelNode);
        }
    }

    private final void addBuildTaskNode(DefaultMutableTreeNode treeNode) {
        Map<String, String> $this$forEach$iv = this.buildMap;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String name = entry.getKey();
            treeNode.add(new DefaultMutableTreeNode(this.prefix + ' ' + name));
        }
    }

    private static final String createToolbar$lambda-1() {
        return "Documentation";
    }

    private static final String createToolbar$lambda-2() {
        return "Setting";
    }
}

