/*
 * Decompiled with CFR 0.152.
 */
package com.kingsoft.shiyou.omnisdk.ide.utils;

import com.android.tools.adtui.validation.Validator;
import com.intellij.openapi.util.io.FileUtil;
import com.kingsoft.shiyou.omnisdk.ide.AllString;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\nJ\u001e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/kingsoft/shiyou/omnisdk/ide/utils/MyWizardUtils;", "", "()V", "VALID_PACKAGE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "VALID_PROJECT", "errorResult", "Lcom/android/tools/adtui/validation/Validator$Result;", "message", "", "validateConfigPath", "configPath", "validateEmpty", "labelName", "value", "validatePackageName", "packageName", "validatePlanId", "", "validateProjectFullPath", "projectPath", "projectName", "validateString", "content", "tag", "IDEPlugin"})
public final class MyWizardUtils {
    @NotNull
    public static final MyWizardUtils INSTANCE = new MyWizardUtils();
    private static final Pattern VALID_PROJECT = Pattern.compile("^([a-zA-Z]++([_]?[a-zA-Z0-9]+)*)++$");
    private static final Pattern VALID_PACKAGE = Pattern.compile("^([a-zA-Z]++([_.]?[a-zA-Z0-9]+)*)++$");

    private MyWizardUtils() {
    }

    @NotNull
    public final Validator.Result validateString(@NotNull String content, @NotNull String labelName, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (Intrinsics.areEqual((Object)content, (Object)labelName)) {
            return this.errorResult(labelName + ' ' + tag);
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result validateEmpty(@NotNull String labelName, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)labelName, (String)"labelName");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (((CharSequence)value).length() == 0) {
            return this.errorResult(labelName + ' ' + AllString.Wizard.INSTANCE.getValidateEmptyText());
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result validatePlanId(int value) {
        if (value == 0) {
            return this.errorResult(AllString.Wizard.INSTANCE.getValidatePlansEmptyText());
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result validateProjectFullPath(@NotNull String projectPath, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        if (((CharSequence)projectName).length() == 0) {
            return this.errorResult("Please enter a name for the project.");
        }
        File loc = new File(FileUtil.toSystemDependentName((String)projectPath), projectName);
        if (loc.exists()) {
            return this.errorResult("Project location already exists: " + loc.getPath());
        }
        if (!VALID_PROJECT.matcher(projectName).matches()) {
            return this.errorResult("Invalid project name: '" + projectName + "' - must be a valid name (letter_with_underscores).");
        }
        if (projectName.length() > 30) {
            return this.errorResult("Invalid project name - must be less than 30 characters.");
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result validatePackageName(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (!VALID_PACKAGE.matcher(packageName).matches()) {
            return this.errorResult("Invalid package name: '" + packageName + "'.");
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result validateConfigPath(@NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        if (!new File(configPath).exists()) {
            return this.errorResult("File location not exists");
        }
        return Validator.Result.OK;
    }

    @NotNull
    public final Validator.Result errorResult(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return new Validator.Result(Validator.Severity.ERROR, message, null, 4, null);
    }
}

