/*
 * Decompiled with CFR 0.152.
 */
package com.kingsoft.shiyou.omnisdk.ide.steps.cps;

import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.project.Project;
import com.kingsoft.shiyou.omnisdk.build.tasks.CpsApkBuildTask;
import com.kingsoft.shiyou.omnisdk.build.utils.LogUtils;
import com.kingsoft.shiyou.omnisdk.ide.OmniMessages;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\u0012H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/kingsoft/shiyou/omnisdk/ide/steps/cps/CpsWizardModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "baseApkFilePath", "Lcom/android/tools/idea/observable/core/StringValueProperty;", "getBaseApkFilePath", "()Lcom/android/tools/idea/observable/core/StringValueProperty;", "cpsFilePath", "getCpsFilePath", "outputPath", "getOutputPath", "getProject", "()Lcom/intellij/openapi/project/Project;", "tag", "", "doCps", "", "baseApk", "Ljava/io/File;", "handleFinished", "IDEPlugin"})
public final class CpsWizardModel
extends WizardModel {
    @NotNull
    private final Project project;
    @NotNull
    private final String tag;
    @NotNull
    private final StringValueProperty baseApkFilePath;
    @NotNull
    private final StringValueProperty cpsFilePath;
    @NotNull
    private final StringValueProperty outputPath;

    public CpsWizardModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tag = "CpsWizardModel";
        this.baseApkFilePath = new StringValueProperty();
        this.cpsFilePath = new StringValueProperty();
        this.outputPath = new StringValueProperty();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StringValueProperty getBaseApkFilePath() {
        return this.baseApkFilePath;
    }

    @NotNull
    public final StringValueProperty getCpsFilePath() {
        return this.cpsFilePath;
    }

    @NotNull
    public final StringValueProperty getOutputPath() {
        return this.outputPath;
    }

    protected void handleFinished() {
        LogUtils.d((String)this.tag, (String)("baseApkFilePath: " + this.baseApkFilePath));
        LogUtils.d((String)this.tag, (String)("cpsFilePath: " + this.cpsFilePath));
        LogUtils.d((String)this.tag, (String)("outputPath: " + this.outputPath));
        File file = new File(this.baseApkFilePath.toString());
        String string = this.cpsFilePath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cpsFilePath.toString()");
        String string2 = this.outputPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputPath.toString()");
        this.doCps(file, string, string2);
        OmniMessages.showDialog("Channel CPS", "CPS \u6253\u5305\u5b8c\u6210\u3002");
    }

    private final void doCps(File baseApk, String cpsFilePath, String outputPath) {
        String string = baseApk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"baseApk.name");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"unsigned", (boolean)false, (int)2, null)) {
            LogUtils.d((String)this.tag, (String)("\u65e0\u6cd5\u5bf9\u672a\u7b7e\u540dapk(" + baseApk.getName() + ")\u8fdb\u884ccps\u51fa\u5305\uff0c\u8df3\u8fc7"));
        } else {
            LogUtils.d((String)this.tag, (String)"now start build channel-cps ...");
            CpsApkBuildTask cpsTask = new CpsApkBuildTask();
            cpsTask.runner(baseApk, new File(cpsFilePath), new File(outputPath + "/single-channel/cps/"));
        }
    }
}

