/*
 * Decompiled with CFR 0.152.
 */
package com.kingsoft.shiyou.omnisdk.ide.steps;

import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.wizard.model.WizardModel;
import com.intellij.openapi.project.Project;
import com.kingsoft.shiyou.omnisdk.build.entity.SaveModel;
import com.kingsoft.shiyou.omnisdk.build.tasks.CreateShiyouTask;
import com.kingsoft.shiyou.omnisdk.build.utils.LogUtils;
import com.kingsoft.shiyou.omnisdk.ide.AllString;
import com.kingsoft.shiyou.omnisdk.ide.ExtensionsKt;
import com.kingsoft.shiyou.omnisdk.ide.OmniMessages;
import com.kingsoft.shiyou.omnisdk.ide.utils.AccountUtils;
import com.kingsoft.shiyou.omnisdk.ide.window.OmniToolWindow;
import com.kingsoft.shiyou.omnisdk.ide.window.OmniToolWindowManager;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/kingsoft/shiyou/omnisdk/ide/steps/ProjectWizardModel;", "Lcom/android/tools/idea/wizard/model/WizardModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "keySign", "Lcom/android/tools/idea/observable/core/StringValueProperty;", "getKeySign", "()Lcom/android/tools/idea/observable/core/StringValueProperty;", "planChannels", "getPlanChannels", "planId", "getPlanId", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectId", "getProjectId", "region", "getRegion", "tag", "", "handleFinished", "", "IDEPlugin"})
public final class ProjectWizardModel
extends WizardModel {
    @NotNull
    private final Project project;
    @NotNull
    private final String tag;
    @NotNull
    private final StringValueProperty projectId;
    @NotNull
    private final StringValueProperty keySign;
    @NotNull
    private final StringValueProperty region;
    @NotNull
    private final StringValueProperty planId;
    @NotNull
    private final StringValueProperty planChannels;

    public ProjectWizardModel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tag = "ProjectWizardModel";
        this.projectId = new StringValueProperty();
        this.keySign = new StringValueProperty();
        this.region = new StringValueProperty();
        this.planId = new StringValueProperty();
        this.planChannels = new StringValueProperty();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final StringValueProperty getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final StringValueProperty getKeySign() {
        return this.keySign;
    }

    @NotNull
    public final StringValueProperty getRegion() {
        return this.region;
    }

    @NotNull
    public final StringValueProperty getPlanId() {
        return this.planId;
    }

    @NotNull
    public final StringValueProperty getPlanChannels() {
        return this.planChannels;
    }

    protected void handleFinished() {
        String string = this.projectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectId.toString()");
        String appId = ((Object)StringsKt.trim((CharSequence)string)).toString();
        String string2 = this.keySign.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keySign.toString()");
        String appKey = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        String string3 = this.region.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"region.toString()");
        boolean oversea = ExtensionsKt.isOversea(string3);
        String string4 = this.planId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"planId.toString()");
        String planIdStr = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        String string5 = this.planChannels.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"planChannels.toString()");
        String channels = string5;
        SaveModel saveModel = new SaveModel(appId, appKey, planIdStr, oversea, channels);
        LogUtils.d((String)this.tag, (String)("planId:" + planIdStr));
        LogUtils.d((String)this.tag, (String)("planChannels:" + channels));
        char[] cArray = appKey.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        AccountUtils.saveAccountInfo(appId, cArray);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"appId", (Object)appId), TuplesKt.to((Object)"appKey", (Object)appKey), TuplesKt.to((Object)"oversea", (Object)String.valueOf(oversea)), TuplesKt.to((Object)"planId", (Object)planIdStr)};
        Map accountInfo = MapsKt.mapOf((Pair[])pairArray);
        new CreateShiyouTask(String.valueOf(this.project.getBasePath())).runner(oversea, channels, accountInfo);
        ExtensionsKt.savePlanContent(this.project, saveModel);
        OmniToolWindow omniToolWindow = OmniToolWindowManager.Companion.getInstance().getToolWindow();
        if (omniToolWindow != null) {
            omniToolWindow.refreshTree();
        }
        OmniMessages.showInfo$default("OmniSDK", AllString.Wizard.INSTANCE.getGuideFinishTips(), this.project, false, 8, null);
    }
}

