#import <Foundation/Foundation.h>
@interface XGPushData : NSObject
@property (nonatomic, strong) NSString *msgId;//消息ID
@property (nonatomic, strong) NSString *process;//消息处理类型 送达：reveive 打开：open 忽略：ignore
@property (nonatomic, strong) NSString *issueAfterOpen;//消息打开后续动作 打开应用：app 打开指定activity:Activity 用户自定义：custom
@property (nonatomic, strong) NSString *deviceToken;//设备会话id
@end

@interface XGDataRoleInfo : NSObject
@property (nonatomic, copy) NSString *uid;
@property (nonatomic, copy) NSString *roleId;
@property (nonatomic, copy) NSString *roleType;
@property (nonatomic, copy) NSString *roleLevel;
@property (nonatomic, copy) NSString *roleVipLevel;
@property (nonatomic, copy) NSString *serverId;
@property (nonatomic, copy) NSString *zoneId;
@property (nonatomic, copy) NSString *roleName;
@property (nonatomic, copy) NSString *serverName;
@property (nonatomic, copy) NSString *zoneName;
@property (nonatomic, copy) NSString *partyName;
@property (nonatomic, copy) NSString *gender;
@property (nonatomic, copy) NSString *balance;
@property (nonatomic, copy) NSString *ageInGame;
@property (nonatomic, copy) NSString *accountAgeInGame;
@property (nonatomic, copy) NSString *roleFigure;
@property (nonatomic, copy) NSString *ext;

@end



/**
 @breif 购买信息属性
 **/
@interface XGDataBuyInfo : NSObject
@property (nonatomic, copy) NSString *tradeSN;
@property (nonatomic, copy) NSString *tokenId;
@property (nonatomic, copy) NSString *accountID;
@property (nonatomic, copy) NSString *productId;
@property (nonatomic, copy) NSString *channelProductId;
@property (nonatomic, copy) NSString *productName;
@property (nonatomic, copy) NSString *productUnit;
@property (nonatomic, copy) NSString *productQuantity;
@property (nonatomic, copy) NSString *productUnitPrice;
@property (nonatomic, copy) NSString *totalAmount;
@property (nonatomic, copy) NSString *payAmount;
@property (nonatomic, copy) NSString *productDesc;
@property (nonatomic, copy) NSString *currencyName;
@property (nonatomic, copy) NSString *roleId;
@property (nonatomic, copy) NSString *roleName;
@property (nonatomic, copy) NSString *roleLevel;
@property (nonatomic, copy) NSString *roleVipLevel;
@property (nonatomic, copy) NSString *serverId;
@property (nonatomic, copy) NSString *zoneId;
@property (nonatomic, copy) NSString *partyName;
@property (nonatomic, copy) NSString *virtualCurrencyBalance;
@property (nonatomic, copy) NSString *customInfo;
@property (nonatomic, copy) NSString *gameTradeNo;
@property (nonatomic, copy) NSString *gameCallbackUrl;
@property (nonatomic, copy) NSString *additionalParams;
@end


@interface SdkBiClient : NSObject


/**
 @brief 开始启动数据统计SDK客户端
 */
+ (void)startStatistic:(NSString *)channelID andOther:(NSDictionary *)other;


//push行为上报接口(废弃)
+ (void)pushEventWithPushInfo:(XGPushData *)pushData;

//push点击推送上报事件
+ (void)pushEventWithEventId:(NSString *)eventId andPushTaskId:(NSString *)pushTaskId;

/**
 @brief 账号登录成功后调用此接口
 */
+ (void)accountLogin:(NSString *)accountID tokenId:(NSString *)tokenId andOther:(NSDictionary *)other;


// 等级提升--去掉roleInfo参数
+ (void)roleLevelUpWithRoleInfo:(XGDataRoleInfo *)xgDataRoleInfo;

/**
 @brief 角色登录成功后调用此接口
 */
+ (void)roleLoginWithRoleInfo:(XGDataRoleInfo *)xgDataRoleInfo other:(NSDictionary *)other;

// 自定义事件
+ (void)onEvent:(NSString *)eventID eventVal:(NSString *)eventVal eventDesc:(NSString *)eventDesc Content:(NSString *)eventContent;


//新增:
//+ (void)onGameEvent:(NSString *)msgType;


//新增:激活礼包码
+ (void)onFunCodeUse:(XGDataRoleInfo *)roleInfo funCode:(NSString *)funCode funCodeDesc:(NSString *)funCodeDesc funCodeType:(NSString *)funCodeType funCodeBatchId:(NSString *)funCodeBatchId funCodeScope:(NSString *)funCodeScope;

// 充值到账
+ (void)payFinish:(XGDataBuyInfo *)xgDataBuyInfo;

/**
 @brief 测试服务器的网络情况
 */
+ (void)networkdelay:(NSString *)serverHost;

/**
 @brief 在即将切换到后台运行时调用此接口
 */
+ (void)onPause:(NSDictionary *)other;

/**
 @brief 在恢复运行时调用此接口
 */
+ (void)onResume:(NSDictionary *)other;


/**
 @brief 发送心跳,300秒一次。
 */
+ (void)sendHeart;



//角色消费
+ (void)roleRechargeWithRechargeChannel:(NSString *)rechargeChannel currency:(NSString *)currency money:(NSString *)money gold:(NSString *)gold bindingGold:(NSString *)bindingGold;

//新增任务开始
+ (void)missionBeginWithRoleInfo:(XGDataRoleInfo *)xgDataRoleInfo missionId:(NSString *)missionId missionName:(NSString *)missionName doMissionTimes:(int)doMissionTimes roleCurrentPower:(int)roleCurrentPower customParams:(NSString *)customParams;

//新增任务成功
+ (void)missionSuccessWithRoleInfo:(XGDataRoleInfo *)xgDataRoleInfo missionId:(NSString *)missionId missionName:(NSString *)missionName doMissionTimes:(int)doMissionTimes roleCurrentPower:(int)roleCurrentPower customParams:(NSString *)customParams;

//新增任务失败
+ (void)missionFailWithRoleInfo:(XGDataRoleInfo *)xgDataRoleInfo missionId:(NSString *)missionId missionName:(NSString *)missionName doMissionTimes:(int)doMissionTimes roleCurrentPower:(int)roleCurrentPower customParams:(NSString *)customParams;


//时间消耗
+ (void)onTimeCost:(NSString *)eventID eventDesc:(NSString *)eventDesc andCostMills:(NSInteger)costMills;

//分类统计
+ (void)onCategoryState:(NSString *)eventID eventDesc:(NSString *)eventDesc andEventVal:(NSString *)eventVal;

//步骤统计
+ (void)onStep:(NSString *)stepNo categoryId:(NSString *)categoryID categoryName:(NSString *)categoryName andStepNoDesc:(NSString *)stepNoDesc;

//虚拟货币购买 增加
//virtualCurrencyType:包括元宝、绑定元宝、银两、声望、真气、家族贡献、侠义、天梯阅历
//virtualCurrencyTotal:，最新的代币数量
+ (void)virtualCurrencyPurchaseWithGold:(NSString *)gold gameTradeNo:(NSString *)gameTradeNo currencyName:(NSString *)currencyName andcurrencyTotal:(NSString *)currencyTotal;

//虚拟货币获赠，增加
//virtualCurrencyType:包括元宝、绑定元宝、银两、声望、真气、家族贡献、侠义、天梯阅历
//virtualCurrencyTotal:，最新的代币数量
//gainChannelType 货币来源分类
+ (void)virtualCurrencyRewardWithGold:(NSString *)gold gameTradeNo:(NSString *)gameTradeNo gainChannel:(NSString *)gainChannel currencyName:(NSString *)currencyName currencyTotal:(NSString *)currencyTotal andGainChannelType:(NSString *)gainChannelType;

//虚拟货币消费，增加
//virtualCurrencyType:包括元宝、绑定元宝、银两、声望、真气、家族贡献、侠义、天梯阅历
//itemNum:标示消费得到的道具的数量
//itemType 道具分类

+ (void)virtualCurrencyConsumeWithGold:(NSString *)gold itemName:(NSString *)itemName currencyName:(NSString *)currencyName currencyTotal:(NSString *)currencyTotal itemNum:(NSString *)itemNum andItemType:(NSString *)itemType;


//增加header key-value
+ (void)addCommonAttribute:(NSString *)key value:(NSString *)value;

//header中增加idfa
+ (void)setIDFA:(NSString *)value;
@end
