//
//  UOPTrackerOC.h
//  OmniSDK
//
//  Created by Yi Liu on 2022/11/30.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
//SDK没有游戏账号，账号类型都为 1，表示非游客
static const NSUInteger NON_GUEST = 1;

@interface UOPTrackerOC : NSObject
+ (void)requestIDFAPermissionWithAppId:(NSString *)appId appName:(NSString *)appName debugMode:(Boolean)debugMode launchOptions:(NSDictionary *)launchOptions
                              complete:(void (^)(NSError * _Nullable err))complete;
+ (void)startAppId:(NSString *)appId appName:(NSString *)appName debugMode:(Boolean)debugMode launchOptions:(NSDictionary *)launchOptions
                 complete:(void (^)(NSError * _Nullable err))complete;

//用户登出操作
+ (void)userLogout;

/*! @abstract 角色注册
 @param method 注册方式，@"douyin"、@"wechat"、@"qq"、@"mobile"、@”weibo“
 @param isSuccess 注册结果
 */
+ (void)trackRegisterWithMethod:(NSString *)method
                userId:(NSString *)userId
             isSuccess:(BOOL)isSuccess;

/*! @abstract 登录请求前
 @param method 注册方式，@"douyin"、@"wechat"、@"qq"、@"mobile"、@”weibo“
 */
+ (void)trackLoginRequestWithMethod:(NSString *)method;

/*! @abstract 登录结果
 @param method 注册方式，@"douyin"、@"wechat"、@"qq"、@"mobile"、@”weibo“
 @param userId 用户唯一标识
 @param isSuccess 登录结果
 */
+ (void)trackLoginResultWithMethod:(NSString *)method
                                 userId:(NSString *)userId
                              isSuccess:(BOOL)isSuccess;

/*! @abstract 支付请求前
 @param userId 用户唯一标识
 @param contentType 商品类型，@”coin“
 @param productId 商品id
 @param productName 商品名称
 @param contentNumber 商品数量
 @param currency 币种，@"CNY"
 @param totalAmount 货币金额，单位：分，不可为0
 */
+ (void)trackPayRequestWithUserId:(NSString *)userId
                           contentType:(NSString *)contentType
                             productId:(NSString *)productId
                           productName:(NSString *)productName
                         contentNumber:(NSUInteger)contentNumber
                              currency:(NSString *)currency
                           totalAmount:(unsigned long long)totalAmount;

/*! @abstract 支付结果
 @param userId 用户唯一标识
 @param orderID 订单号
 @param merchantId 商户id
 @param contentType 商品类型，@”coin“
 @param productId 商品id
 @param productName 商品名称
 @param contentNumber 商品数量
 @param currency 币种，@"CNY"
 @param totalAmount 商品货币金额，单位：分，不可为0
 @param acturallyAmount 实际支付金额，单位：分，一般等于支付金额
 @param isSuccess 支付结果
 */
+ (void)trackPayResultWithUserId:(NSString *)userId
                              orderID:(NSString *)orderID
                           merchantId:(NSString *)merchantId
                          contentType:(NSString *)contentType
                            productId:(NSString *)productId
                          productName:(NSString *)productName
                        contentNumber:(NSUInteger)contentNumber
                             currency:(NSString *)currency
                          totalAmount:(unsigned long long)totalAmount
                      acturallyAmount:(NSInteger)acturallyAmount
                            isSuccess:(BOOL)isSuccess;

/**
 注册用户归因状态通知
 */
+ (void)registUserAggregationStatusNotification;

@end

NS_ASSUME_NONNULL_END
