//
//  DouyinOSDKWrapper.h
//  OmniDouyinOS
//
//  Created by 程小康 on 2025/9/9.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface DouyinOSDKWrapper : NSObject

+ (instancetype)getInstance;

/// SDK初始化接口
/// @param configFilePath 配置文件沙盒路径
/// @discussion 读取传入的UOPSDKConfig.json沙盒文件路径，不采集任何隐私信息
+ (void)setupWithConfigFilePath:(NSString *)configFilePath;
/// SDK启动接口
/// @param completion SDK启动结果回调
/// @discussion 调用该接口前必须先调用初始化接口，将使用配置接口传入的配置文件启动SDK基础功能，需在用户同意隐私协议后调用；需要该接口回调返回成功才能保证其他功能的正常使用
+ (void)startOSDKWithCompletion:(void(^)(NSError * _Nullable err))completion;

/// SDK带启动参数启动接口，与SDK启动接口二选一即可
/// @param extra SDK启动配置，可传空
/// @param completion SDK启动结果回调
/// @discussion 调用该接口前必须先调用初始化接口，将使用配置接口传入的配置文件启动SDK基础功能，需在用户同意隐私协议后调用；需要该接口回调返回成功才能保证其他功能的正常使用
+ (void)startOSDKWithConfig:(NSDictionary * _Nullable)extra completion:(void(^)(NSError * _Nullable err))completion;

/// SDK是否已启动
/// @discussion SDK初始化与启动两步操作均完成且成功返回YES，否则返回NO。
+ (BOOL)isStarted;

+ (BOOL)onGameActive;

+ (BOOL)onAccountRegister:(NSString *)gameUserID;

+ (BOOL)onAccountLogin:(NSString *)gameUserID
         lastLoginTime:(int64_t)lastLoginTime;

+ (BOOL)onRoleLogin:(NSString *)gameUserID
         gameRoleID:(NSString *)gameRoleID
  lastRoleLoginTime:(int64_t)lastRoleLoginTime;

+ (BOOL)onPay:(NSString *)gameUserID
   gameRoleID:(NSString * _Nullable)gameRoleID
  gameOrderID:(NSString *)gameOrderID
  totalAmount:(int64_t)totalAmount
  productID:(NSString * _Nullable)productID
  productName:(NSString * _Nullable)productName
  productDesc:(NSString * _Nullable)productDesc;
@end

NS_ASSUME_NONNULL_END
