#if UNITY_WEBGL
using System;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using Newtonsoft.Json;
using UnityEngine;

namespace Combo.Platform
{
    public class NativeWebGL : MonoBehaviour
    {
        private static Action<Result<SetupResult>> setupFinishedAction;
        private static Action<Result<LoginResult>> loginFinishedAction;
        private static Action<Result<PurchaseResult>> purchaseFinishedAction;

        [DllImport("__Internal")]
        private static extern void freeMemory(IntPtr pointer);

        [DllImport("__Internal")]
        private static extern void setup(string strJsonData);
        public static void Setup(SetupOptions opts, Action<Result<SetupResult>> callback)
        {
            GameObject obj = GameObject.Find("ComboSDKWebGL");

            if (obj == null)
            {
                obj = new GameObject("ComboSDKWebGL", typeof(NativeWebGL));
                DontDestroyOnLoad(obj);
            }
            setupFinishedAction = callback;
            setup(opts.ToJson());
        }

        [DllImport("__Internal")]
        private static extern void login();
        public static void Login(Action<Result<LoginResult>> callback)
        {
            loginFinishedAction = callback;
            login();
        }

        [DllImport("__Internal")]
        private static extern IntPtr getParameters();
        public static Dictionary<string, string> GetParameters()
        {
            var resultPtr = getParameters();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            var parameters = JsonConvert.DeserializeObject<Dictionary<string, string>>(jsonString);
            freeMemory(resultPtr);
            return parameters;
        }

        [DllImport("__Internal")]
        public static extern void purchase(string strJsonData);
        public static void Purchase(PurchaseOptions opts, Action<Result<PurchaseResult>> callback)
        {
            purchaseFinishedAction = callback;
            purchase(opts.ToJson());
        }

        [DllImport("__Internal")]
        public static extern bool isFeatureAvailable(int feature);
        public static bool IsFeatureAvailable(Feature feature)
        {
            return isFeatureAvailable((int)feature);
        }

        [DllImport("__Internal")]
        public static extern void contactSupport();
        public static void ContactSupport()
        {
            contactSupport();
        }

        [DllImport("__Internal")]
        public static extern IntPtr getLoginInfo();
        public static LoginInfo GetLoginInfo()
        {
            var resultPtr = getLoginInfo();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            var info = JsonConvert.DeserializeObject<LoginInfo>(jsonString);
            freeMemory(resultPtr);
            return info;
        }

        [DllImport("__Internal")]
        public static extern IntPtr getUserId();
        public static string GetUserId()
        {
            var resultPtr = getUserId();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            freeMemory(resultPtr);
            return jsonString;
        }

        [DllImport("__Internal")]
        public static extern IntPtr getDistro();
        public static string GetDistro()
        {
            var resultPtr = getDistro();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            freeMemory(resultPtr);
            return jsonString;
        }

        [DllImport("__Internal")]
        public static extern IntPtr getVersion();
        public static string GetVersion()
        {
            var resultPtr = getVersion();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            freeMemory(resultPtr);
            return jsonString;
        }

        [DllImport("__Internal")]
        public static extern IntPtr getDeviceId();
        public static string GetDeviceId()
        {
            var resultPtr = getDeviceId();
            string jsonString = Marshal.PtrToStringAuto(resultPtr);
            freeMemory(resultPtr);
            return jsonString;
        }

        public void _SetupSucceed(string msg)
        {
            var result = Result<SetupResult>.CreateSuccessFromJson(msg);
            setupFinishedAction?.Invoke(result);
        }

        public void _SetupFailed(string msg)
        {
            var result = Result<SetupResult>.CreateFailFromJson(msg);
            setupFinishedAction?.Invoke(result);
        }

        public void _LoginSucceed(string msg)
        {
            var result = Result<LoginResult>.CreateSuccessFromJson(msg);
            loginFinishedAction?.Invoke(result);
        }

        public void _LoginFailed(string msg)
        {
            var result = Result<LoginResult>.CreateFailFromJson(msg);
            loginFinishedAction?.Invoke(result);
        }

        public void _PurchaseSucceed(string msg)
        {
            var result = Result<PurchaseResult>.CreateSuccessFromJson(msg);
            purchaseFinishedAction?.Invoke(result);
        }

        public void _PurchaseFailed(string msg)
        {
            var result = Result<PurchaseResult>.CreateFailFromJson(msg);
            purchaseFinishedAction?.Invoke(result);
        }
    }
}
#endif