#import "UnityAppController.h"
#import <ComboSDK/ComboSDK-Swift.h>

@interface ComboSDKAppController : UnityAppController
@property (nonatomic, assign) Boolean isEulaAgreed;
@end

IMPL_APP_CONTROLLER_SUBCLASS (ComboSDKAppController)

@implementation ComboSDKAppController

- (BOOL)application:(UIApplication*)application didFinishLaunchingWithOptions:(NSDictionary*)launchOptions
{
    [ComboSDK.shared application:application didFinishLaunchingWithOptions:launchOptions];
    EulaViewController * eulaController = [[EulaViewController alloc] init];
    _isEulaAgreed = eulaController.eulaDidAgreed;
    if (_isEulaAgreed) {
        [super application:application didFinishLaunchingWithOptions:launchOptions];
        return YES;
    }
    _window = [[UIWindow alloc] init];
    eulaController.agreeAction = ^{
        _isEulaAgreed = YES;
        [super application:application didFinishLaunchingWithOptions:launchOptions];
        [super applicationDidBecomeActive:application];
    };
    _window.rootViewController = eulaController;
    [_window makeKeyAndVisible];

    return YES;
}

- (void)applicationDidBecomeActive:(UIApplication *)application{
    [[ComboSDK shared] applicationDidBecomeActive:application];
    if (_isEulaAgreed) {
        [super applicationDidBecomeActive:application];
    }
}

// 此时 Unity 还没启动,无法获取游戏屏幕方向,需要从 info.plist 中读取配置
- (UIInterfaceOrientationMask)application:(UIApplication *)application supportedInterfaceOrientationsForWindow:(UIWindow *)window {
    NSString *comboOrientation = [[ComboSDK shared] application:application supportedInterfaceOrientationsFor:window];
    if ([comboOrientation isEqualToString:@"portrait"]) {
        return UIInterfaceOrientationMaskPortrait;
    }
    if ([comboOrientation isEqualToString:@"landscape"]) {
        return UIInterfaceOrientationMaskLandscape;
    }
    NSArray *supportedOrientations;
    if (UI_USER_INTERFACE_IDIOM() == UIUserInterfaceIdiomPad) {
        // iPad
        supportedOrientations = [[NSBundle mainBundle] infoDictionary][@"UISupportedInterfaceOrientations~ipad"];
    } else {
        // iPhone
        supportedOrientations = [[NSBundle mainBundle] infoDictionary][@"UISupportedInterfaceOrientations"];
    }

    UIInterfaceOrientationMask supportedOrientationsMask = 0;
    for (NSString *orientation in supportedOrientations) {
        if ([orientation isEqualToString:@"UIInterfaceOrientationPortrait"]) {
            supportedOrientationsMask |= UIInterfaceOrientationMaskPortrait;
        } else if ([orientation isEqualToString:@"UIInterfaceOrientationLandscapeLeft"]) {
            supportedOrientationsMask |= UIInterfaceOrientationMaskLandscapeLeft;
        } else if ([orientation isEqualToString:@"UIInterfaceOrientationLandscapeRight"]) {
            supportedOrientationsMask |= UIInterfaceOrientationMaskLandscapeRight;
        } else if ([orientation isEqualToString:@"UIInterfaceOrientationPortraitUpsideDown"]) {
            supportedOrientationsMask |= UIInterfaceOrientationMaskPortraitUpsideDown;
        }
    }
    return supportedOrientationsMask;
}

- (void)application:(UIApplication *)application didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {
#if UNITY_USES_REMOTE_NOTIFICATIONS
   [[ComboSDK shared] application:application didRegisterForRemoteNotificationsWithDeviceToken:deviceToken];
   [super application:application didRegisterForRemoteNotificationsWithDeviceToken: deviceToken];
#endif
}

- (BOOL)application:(UIApplication *)application continueUserActivity:(NSUserActivity *)userActivity restorationHandler:(void (^)(NSArray<id<UIUserActivityRestoring>> * _Nullable))restorationHandler {
    [[ComboSDK shared] application:application continue:userActivity];
    [super application:application continueUserActivity:userActivity restorationHandler:^(NSArray<id<UIUserActivityRestoring>> * _Nullable restorableObjects) {
         restorationHandler(@[]);
     }];
    return YES;
}

- (BOOL)application:(UIApplication *)app openURL:(NSURL *)url options:(NSDictionary<UIApplicationOpenURLOptionsKey,id> *)options {
    [[ComboSDK shared] application:app open:url options:options];
    return [super application:app openURL:url options:options];
}

@end
