
using System.Collections;
using _Core;
using UnityEngine;

namespace Seayoo.ComboSDK.Windows.Store.View
{
    internal class PayView : MonoBehaviour
    {
        public PayMethodView payMethodView;
        public QRCodePayView qRCodePayView;
        public PurchaseSuccessView purchaseSuccessView;
        void Awake()
        {
            EventSystem.Register(this);
        }

        void Start()
        {
            StartCoroutine(AttachEventSystemCoroutine());  
        }

        private IEnumerator AttachEventSystemCoroutine()
        {
            yield return null; // 等待一帧，确保销毁操作完成

            var eventSystem = FindObjectOfType<UnityEngine.EventSystems.EventSystem>();
            if (eventSystem == null)
            {
                Log.I("Attach EventSystem and StandaloneInputModule.");
                gameObject.AddComponent<UnityEngine.EventSystems.EventSystem>();
                gameObject.AddComponent<UnityEngine.EventSystems.StandaloneInputModule>();
            }
            else
            {
                Log.I("Existed EventSystem.");
            }
        }

        void OnDestroy()
        {
            EventSystem.UnRegister(this);
        }

        [EventSystem.BindEvent]
        void OnCloseWindow(ClosePayViewCommand action)
        {
            Destroy(this.gameObject);
        }
    }
}