using System;
using System.Collections;
using _Core;
using UnityEngine.UI;


namespace _Combo
{
    [ViewPrefab("Prefabs/ComboActivationView")]
    internal class ActivationView : View<ActivationView>
    {
        public Text titleTxt;
        public Text infoTxt;
        public Text keyText;
        public Text activateText;
        public InputField keyField;
        public Button activateBtn;
        public Button closeBtn;
        private Action OnClose;

        void Awake() {
            titleTxt.text = I18n.T("activation_title");
            infoTxt.text = I18n.T("activation_text");
            keyText.text = I18n.T("activation_placeholder");
            activateText.text = I18n.T("activation_button");
        }

        void OnDestroy()
        {
            closeBtn.onClick.RemoveListener(OnCloseClicked);
            activateBtn.onClick.RemoveListener(OnActivateClicked);
            keyField.onValueChanged.RemoveListener(OnKeyFieldChanged);
        }

        void Start()
        {
            closeBtn.onClick.AddListener(OnCloseClicked);
            activateBtn.onClick.AddListener(OnActivateClicked);
            keyField.onValueChanged.AddListener(OnKeyFieldChanged);
        }

        void OnKeyFieldChanged(string newValue)
        {
            keyField.text = newValue.Replace(" ", "");
        }

        public void SetCloseCallback(Action OnClose)
        {
            this.OnClose = OnClose;
        }

        public void OnActivateClicked()
        {
            var key = keyField.text;

            if (string.IsNullOrEmpty(key))
            {
                UIController.Instance.ShowToast(I18n.T("activation_required_toast"));
                return;
            }

            activateBtn.interactable = false;
            IdPManager.Instance.ActivatePlayer(key, (isSuccess)=> {
                if (isSuccess)
                {
                    Destroy();
                }
                activateBtn.interactable = true;
            });
        }

        public void OnCloseClicked()
        {
            Destroy();
            IdPManager.Instance.Login();
        }

        protected override IEnumerator OnHide()
        {
            yield return null;
        }

        protected override IEnumerator OnShow()
        {
            yield return null;
        }

        
    }
}
