using System;
using _Core;

namespace _Combo
{
    public class NetworkError : BaseCause
    {
        
        public string Url { get; set; } = "";
        public string DetailMessage { get; set; } = "";
        public Exception Cause { get; set; }
        public override bool EnableTracking {
            get { return true;}
        }
        public NetworkError(string url = "", string message = "", Exception cause = null)
        {
            Url = url;
            DetailMessage = message;
            Cause = cause;
        }
        public override string GetMessage()
        {
            return I18n.T("network_error");
        }

        public override string ToString()
        {
            string result = "NetworkError";
            
            if (!string.IsNullOrEmpty(Url))
            {
                result += $"\nurl = {Url}";
            }
            if (!string.IsNullOrEmpty(DetailMessage))
            {
                result += $"\nerrorMessage = {DetailMessage}";
            }
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }

            return result;
        }
    }
}