using System;
using System.Collections.Generic;
using _Combo;
using Sentry;

public interface IErrorTracking
{
    void Setup();
    void SetTags(Dictionary<string, string> tagMap);
    void SetUser(string id, Dictionary<string, string> extra = null);
    void SetBreadcrumbs(List<EventBreadcrumb> breadcrumbs);
    void SetContexts(Dictionary<string, object> contextMap);
    void SetExtra(Dictionary<string, string> extra);
    void SetFingerprint(List<string> fingerprint);
    void CaptureMessage(string message, SentryLevel eventLevel, EventScope eventScope = null);
    void CaptureException(Exception exception, EventScope eventScope= null);
}