using System;
using _Core;
using Seayoo.ComboSDK.Windows.Store.Networking;
using Seayoo.ComboSDK.Windows.Store.Networking.Model;
using Seayoo.ComboSDK.Windows.Store.View;

namespace Seayoo.ComboSDK.Windows.Store
{
    public class SeayooStoreManager : Singleton<SeayooStoreManager>
    {
        private SeayooStoreManager() { }
        private static SeayooStoreManager _instance;

        public static SeayooStoreManager GetInstance()
        {
            if (_instance == null)
            {
                if (_instance == null)
                {
                    _instance = new SeayooStoreManager();
                }
            }
            return _instance;
        }

        public void RequestPayment(string orderToken, string method, Action<string, int> onResp)
        {
            SeayooStoreClient.RequestPayment(orderToken, method, resp =>
            {
                if (method == GetPaymentMethodName(PaymentMethods.WEIXIN_NATIVE))
                {
                    var args = (RequestPayment.WeixinNativePaymentArgs)resp.Data.paymentArgs;
                    onResp.Invoke(args.codeUrl, args.timeExpire);
                }
                else if (method == GetPaymentMethodName(PaymentMethods.ALIPAY_QR_CODE))
                {
                    var args = (RequestPayment.AlipayQrCodePaymentArgs)resp.Data.paymentArgs;
                    onResp.Invoke(args.qrCode, args.timeExpire);
                }
                else if (method == GetPaymentMethodName(PaymentMethods.SEAYOO_SANDBOX))
                {
                    var paymentMethod = PaymentMethods.SEAYOO_SANDBOX;
                    QueryPayment(orderToken, GetPaymentMethodName(paymentMethod));
                }
            }, (error) =>
            {

            });
        }

        public void QueryPayment(string orderToken, string method)
        {
            SeayooStoreClient.QueryPayment(orderToken, method, result =>
            {
                if (result.Data.paymentStatus == "paid")
                {
                    var status = PaymentStatus.PAID;
                    QueryPaymentResultsCommand.Invoke(new QueryPaymentResultsCommand
                    {
                        status = status,
                        method = GetPaymentMethod(method)
                    });
                }
            }, (error) =>
            {

            });
        }


        public string GetPaymentMethodName(PaymentMethods paymentMethods)
        {
            switch (paymentMethods)
            {
                case PaymentMethods.WEIXIN_NATIVE:
                    return "weixin_native";
                case PaymentMethods.ALIPAY_QR_CODE:
                    return "alipay_qr_code";
                case PaymentMethods.SEAYOO_SANDBOX:
                    return "seayoo_sandbox";
                default:
                    return "";
            }
        }
        
        public PaymentMethods GetPaymentMethod(string methodName)
        {
            switch (methodName)
            {
                case "weixin_native":
                    return PaymentMethods.WEIXIN_NATIVE;
                case "alipay_qr_code":
                    return PaymentMethods.ALIPAY_QR_CODE;
                case "seayoo_sandbox":
                    return PaymentMethods.SEAYOO_SANDBOX;
                default:
                    return PaymentMethods.WEIXIN_NATIVE;
            }
        }
    }
}