using _Core;
using UnityEngine;
using UnityEngine.Scripting;
using _Combo;
using Seayoo.ComboSDK.Windows.Store.Networking;
using Seayoo.ComboSDK.Windows.Store.View;

namespace Seayoo.ComboSDK.Windows.Store
{
    [Preserve]
    public class SeayooStore : Singleton<SeayooStore>, IStore
    {
        public SeayooStore() { }
        private GameObject storePrefab;

        public void Setup(StoreParameters storeParameters)
        {
            SeayooStoreClient.Setup(storeParameters);
        }

        public void Purchase(string orderToken, Order order, PurchaseOptions purchaseOptions)
        {
            Purchase(orderToken, order, (SeayooPurchaseOptions)purchaseOptions, null);
        }

        private void Purchase(string orderToken, Order order, SeayooPurchaseOptions seayooPurchaseOptions, GameObject root = null)
        {
            if (storePrefab == null)
            {
                storePrefab = GameObject.Instantiate(Resources.Load("Prefabs/PayView")) as GameObject;
                if (root != null)
                {
                    Canvas canvas = root.GetComponent<Canvas>();
                    if (canvas != null)
                    {
                        Log.E("Do not attach seayooStore prefab to Canvas Component!!!");
                        return;
                    }
                    storePrefab.transform.SetParent(root.transform, false);
                }
                Log.I("Add ComboSDK SeayooStore Prefabs");
                ProductInfoCommand.Invoke(new ProductInfoCommand{
                    orderToken = orderToken,
                    order = order,
                    seayooPurchaseOptions = seayooPurchaseOptions
                });
            }
            else
            {
                Log.I("Prefab already exists, not creating a new one.");
            }
        }


        public string GetStore()
        {
            return "seayoo";
        }

        public bool IsFeatureAvailable(Feature feature)
        {
            return feature == Feature.PRODUCT_QUANTITY;
        }
    } 
}
