using System;
using _Combo;
using _Core;
using Seayoo.ComboSDK.Windows.Account.Model.Net;

namespace Seayoo.ComboSDK.Windows.Account.View
{

    public class GetLoginOptionsCommand : Event<GetLoginOptionsCommand>
    {
        public string account;
        public Action<GetLoginOptionsResponse> OnSuccess;
        public Action<InternalError> OnFail;
    }

    public class PhoneLoginCommand : Event<PhoneLoginCommand>
    {
        public string mobile;
        public string otp;
        public string action;
    }

    public class CloseWindowCommand : Event<CloseWindowCommand>
    {
        public bool userCancel;
    }

    public class TokenLoginCommand : Event<TokenLoginCommand>
    {
        public string userId;
        public string token;
    }

    public class RealNameCommand : Event<RealNameCommand>
    {
        public string userId;
        public string token;
        public string realName;
        public string identityCard;
        public bool encrypted;
    }

    public class CreateCaptchaCommand : Event<CreateCaptchaCommand>
    {
        public string account;
        public string action;
        public Action<CreateCaptchaResponse> OnSuccess;
        public Action OnFail;
    }

    public class CreateLoginOTPCommand : Event<CreateLoginOTPCommand>
    {
        public string mobile;
        public string captchaId;
        public string captchaResult;
        public Action<string> OnSuccess;
        public Action OnFail;
    }

    public class DeleteUserHistoryCommand : Event<DeleteUserHistoryCommand>
    {
        public string userId;
    }

    public class RefreshViewCommand : Event<RefreshViewCommand>
    {
    }

    public class GoToViewCommand : Event<GoToViewCommand>
    {
        public SeayooAccountViewType viewType;
        public object vo;
    }

    public class PasswordLoginCommand : Event<PasswordLoginCommand>
    {
        public string username;
        public string password;
        public bool encrypted;
        public string captchaId;
        public string captchaResult;
    }

    public class CreateDeviceGrantOTPCommand : Event<CreateDeviceGrantOTPCommand>
    {
        public string ticket;
        public Action<string> OnSuccess;
        public Action OnFail;
    }

    public class GrantDeviceWithOTPCommand : Event<GrantDeviceWithOTPCommand>
    {
        public string ticket;
        public string otp;
    }

    public class LinkIdentityCommand : Event<LinkIdentityCommand>
    {
        public string mobile;
        public string otp;
        public string action;
        public Credential credential;
    }

    public class LinkIdentitySuccessCommand : Event<LinkIdentitySuccessCommand>
    {
        public Credential credential;
    }

    public class ShowLoginViewCommand : Event<ShowLoginViewCommand> { }

    public class LinkRealNameCommand : Event<LinkRealNameCommand>
    {
        public string userId;
        public string token;
        public string realName;
        public string identityCard;
        public bool encrypted;
        public Credential linkCredential;
    }

    public class DropdownTemplateIsShowCommand : Event<DropdownTemplateIsShowCommand>
    {
        public bool isShow;
    }
}