using System;
using System.Collections;
using _Core;
using UnityEngine;
#if UNITY_STANDALONE
using Vuplex.WebView;
#endif

namespace _Combo
{
    public class UIController : Singleton<UIController>
    {
        public void ShowWelcomeView(string user, Action OnSwitchAccount, Action OnShowCompleted, Credential credential) {
            WelcomeView.DestroyAll();
            var abortShowCompleted = false;
            var view = WelcomeView.Instantiate();
            view.SetUserName(user);
            view.SetSwitchAccountCallback(() => {
                view.Destroy();
                abortShowCompleted = true;
                OnSwitchAccount.Invoke();
            }); 
            view.SetImage(credential);
            view.Show(new ViewCallbacks {
                AfterShow = () => {
                    view.Invoke(nameof(view.Hide), 3.0f);
                },
                BeforeHide = () => {
                    if (!abortShowCompleted)
                    {
                        OnShowCompleted?.Invoke();
                    }
                },
                AfterHide = () => {
                    view.Destroy();
                }
            });
        }

        public void ShowAlertView(string title, string message, TextAnchor textAnchor, string oneBtnTxt, Action OnAction, int time = 0) {
            var alertView = AlertView.Instantiate();
            alertView.SetTitle(title);
            alertView.SetMessage(message, textAnchor);
            alertView.SetOneBtnTitle(oneBtnTxt, time);
            alertView.SetCancelCallback(OnAction);
            alertView.ShowOneBtn();
            alertView.SetCancelCallback(() => {
                alertView.Destroy();
                OnAction.Invoke();
            });
            alertView.Show();
        }

        public void ShowAlertView(string title, string message, TextAnchor textAnchor, string twoLeftBtnTxt, string twoRightBtnTxt, Action OnLeftAction, Action OnRightAction, int sortOrder = 999) {
            var alertView = AlertView.Instantiate();
            alertView.SetTitle(title);
            alertView.SetMessage(message, textAnchor);
            alertView.SetRightBtnTitle(twoRightBtnTxt);
            alertView.SetLeftBtnTitle(twoLeftBtnTxt);
            alertView.ShowTwoBtn();
            alertView.SetConfirmCallback(() => {
                alertView.Destroy();
                OnRightAction.Invoke();
            });
            alertView.SetCancelCallback(() => {
                alertView.Destroy();
                OnLeftAction.Invoke();
            });
            alertView.SetSortOrder(sortOrder);
            alertView.Show();
        }

        public void ShowToast(string text, float duration = 3f) {
            ToastView.DestroyAll();
            var view = ToastView.Instantiate();
            view.SetText(text);
            view.Show(new ViewCallbacks {
                AfterShow = () => {
                    view.Invoke(nameof(view.Hide), duration);
                },
                AfterHide = () => {
                    view.Destroy();
                }
            });
        }

        public void ShowLoading(float thresholdTime = 0) {
            if(LoadingView.HasInstances())
            {
                return;
            }
            var view = LoadingView.Instantiate();
            view.SetThresholdTime(thresholdTime);
            view.Show(false);
        }

        public void HideLoading() {
            LoadingView.DestroyAll();
        }

        public void ShowActivationView(string ticket) {
            var view = ActivationView.Instantiate();
            view.SetCloseCallback(() => {
                view.Destroy();
            });
            view.Show();
        }

#if UNITY_STANDALONE
        public void ShowWebView(string url, WebViewType type, int width = 0, int height = 0, bool showNavigationBar = true, bool backgroundEnable = false, DragMode dragMode = DragMode.DragWithinPage, Action onClose = null)
        {
            var view = WebView.Instantiate();
            view.SetUrl(url);
            view.SetWidthAndHeight(width, height);
            view.SetType(type);
            view.SetDefaultBackgroundEnabled(backgroundEnable);
            view.SetShowNavigationBar(showNavigationBar);
            view.SetDragMode(dragMode);
            view.SetCloseAction(onClose);  
            view.Show();
        }
#endif
    }
}
