using System;
using _Core;

namespace _Combo
{
    public class InternalError : Exception
    {
        override public string Message { get; } = "";
        public Exception Cause { get; private set; } = null;

        public string DetailMessage
        {
            get
            {
                var detailMessage = $"errorMessage = {Message}";
                if(Cause != null)
                {
                    detailMessage += $"\ncause = {Cause}";
                }
                return detailMessage;
            }
        }

        public InternalError(Exception cause) : base(null, cause)
        {
            Cause = cause;
            if (cause is BaseCause baseCause)
            {
                Message = baseCause.GetMessage();
            }
            else
            {
                Message = I18n.T("system_error");
            }
        }

        public InternalError(string errorMsg = "", Exception cause = null)
        {
            Message = errorMsg;
            Cause = cause;
        }
    }

    public static class ErrorExtensions
    {
        public static T Convert<T>(this InternalError error) where T : Exception
        {
            var cause = error?.Cause;
            if (cause is T)
            {
                return (T)cause;
            }
            return null;
        }
    }
}
