using System;

namespace Seayoo.ComboSDK.Windows
{
    public class ComboSDKResult<T>
    {
        public T value { get; private set; }
        public ComboSDKError error { get; private set; }

        private ComboSDKResult() { }

        public static ComboSDKResult<T> Success(T _value)
        {
            return new ComboSDKResult<T> { value = _value };
        }

        public static ComboSDKResult<T> Failure(ComboSDKError _error)
        {
            return new ComboSDKResult<T> { error = _error };
        }

        public bool IsSuccess()
        {
            return error == null;
        }

        public T Get()
        {
            if (!IsSuccess())
            {
                throw new InvalidOperationException("ComboSDKResult is a failure. Use `Error` property.");
            }

            return value;
        }

        public ComboSDKError GetError()
        {
            if (IsSuccess())
            {
                throw new InvalidOperationException("ComboSDKResult is a success. Use `Get` method.");
            }

            return error;
        }
    }
}
