mergeInto(LibraryManager.library, {
    // 声明全局变量 ComboSDK
    ComboSDK: null,
    
    setup: function (strJsonDataPtr) {
        const strJsonData = UTF8ToString(strJsonDataPtr);
        console.log("[ComboSDKWebGLWrapper] Setup data:", strJsonData);
        const setupOptions = JSON.parse(strJsonData);

        GameGlobal.ComboSDK.setup(setupOptions, result => {
            if (result.error == null) {
                const successMessage = JSON.stringify({});
                SendMessage("ComboSDKWebGL", "_SetupSucceed", successMessage);
            } else {
                const failureMessage = JSON.stringify({ error: result.error.name, message: result.error.message, detailMessage: result.error.detailMessage });
                SendMessage("ComboSDKWebGL", "_SetupFailed", failureMessage);
            }
        });
    },

    getParameters: function () {
        if (typeof wx !== 'undefined' && typeof wx.getSystemInfoSync === 'function') {
            console.log("[ComboSDKWebGLWrapper] Running in wx environment");

            if (!GameGlobal.ComboSDK) {
                const comboModule = require('./combosdk/combosdk.js');           
                GameGlobal.ComboSDK = comboModule.ComboSDK;
            }
        }

        const parametersMap = GameGlobal.ComboSDK.getParameters();
        const parametersObject = Object.fromEntries(parametersMap);
        const jsonString = JSON.stringify(parametersObject);
        const parameters = allocate(intArrayFromString(jsonString), 'i8', ALLOC_STACK);
        return parameters;
    },

    login: function () {
        console.log("[ComboSDKWebGLWrapper] Login called");
        
        GameGlobal.ComboSDK.login(result => {
            if (result.error == null) {
                const successMessage = JSON.stringify({ loginInfo: {comboId: result.loginInfo.comboId, identityToken: result.loginInfo.identityToken, idp: result.loginInfo.idp }} );
                SendMessage("ComboSDKWebGL", "_LoginSucceed", successMessage);
            } else {
                const failureMessage = JSON.stringify({ error: result.error.name, message: result.error.message, detailMessage: result.error.detailMessage });
                SendMessage("ComboSDKWebGL", "_LoginFailed", failureMessage);
            }
        });
    },

    purchase: function (strJsonDataPtr) {
        console.log("[ComboSDKWebGLWrapper] Purchase called");

        const strJsonData = UTF8ToString(strJsonDataPtr);
        console.log("[ComboSDKWebGLWrapper] Purchase data:", strJsonData);
        const prucaseOptions = JSON.parse(strJsonData);

        GameGlobal.ComboSDK.purchase(prucaseOptions, (result) => {
            if (result.error == null) {
                const successMessage = JSON.stringify({ orderId: result.purchaseInfo.orderId });
                SendMessage("ComboSDKWebGL", "_PurchaseSucceed", successMessage);
            } else {
                const failureMessage = JSON.stringify({ error: result.error.name, message: result.error.message, detailMessage: result.error.detailMessage });
                SendMessage("ComboSDKWebGL", "_PurchaseFailed", failureMessage);
            }
        });
    },

    isFeatureAvailable: function (integerValue) {
        console.log("[ComboSDKWebGLWrapper] isFeatureAvailable integerValue:", integerValue);
        return GameGlobal.ComboSDK.isFeatureAvailable(integerValue);
    },

    contactSupport: function () {
        console.log("[ComboSDKWebGLWrapper] contactSupport called");
        GameGlobal.ComboSDK.contactSupport();
    },

    getLoginInfo: function () {
        console.log("[ComboSDKWebGLWrapper] getLoginInfo called");
        const info = GameGlobal.ComboSDK.getLoginInfo();
        const loginInfo = JSON.stringify({ comboId: info.comboId, identityToken: info.identityToken, idp: info.idp} );
        const parameters = allocate(intArrayFromString(loginInfo), 'i8', ALLOC_STACK);
        return parameters;
    },

    getUserId: function () {
        console.log("[ComboSDKWebGLWrapper] getUserId called");
        return allocate(intArrayFromString(GameGlobal.ComboSDK.getUserId()), 'i8', ALLOC_STACK);
    },

    getDistro: function () {
        console.log("[ComboSDKWebGLWrapper] getDistro called");
        return allocate(intArrayFromString(GameGlobal.ComboSDK.getDistro()), 'i8', ALLOC_STACK);
    },

    getVersion: function () {
        console.log("[ComboSDKWebGLWrapper] getVersion called");
        return allocate(intArrayFromString(GameGlobal.ComboSDK.getVersion()), 'i8', ALLOC_STACK);
    },
    
    getDeviceId: function () {
        console.log("[ComboSDKWebGLWrapper] getDeviceId called");
        return allocate(intArrayFromString(GameGlobal.ComboSDK.getDeviceId()), 'i8', ALLOC_STACK);

    },
});