#import <ComboSDK/ComboSDK-Swift.h>


@interface ComboSDKIOSWrapper : NSObject
{
}

+ (instancetype) shareInstance;

- (void)setup:(NSString*)jsonData;
- (void)login;
- (void)logout;
- (void)purchase:(NSString*)jsonData;
- (NSString*)getUserInfo;
- (NSString*)getVersion;
- (NSString*)getDistro;
- (NSString*)getDeviceId;
- (NSString*)getParameters;
- (void)preloadAd:(NSString*)jsonData;
- (void)showAd:(NSString*)jsonData;
- (void)share:(NSString*)type jsonData:(NSString*)jsonData;
- (void)openAppSettings;
- (NSString*)getUserId;
- (void)manageAccount;
- (void)deleteAccount;
- (void)changePassword;
- (void)contactSupport;
- (Boolean)isFeatureAvailable:(NSString*)feature;
- (void)openGameUrlWithController:(NSString*)gameUrl;
- (void)getDownloadUrl;
- (NSArray*)getAvailableShareTargets;
- (void)openShortLink:(NSString*)link gameData:(NSString*)gameData;
- (void)checkAnnouncements:(NSString*)jsonData;
- (void)openAnnouncements:(NSString*)jsonData;
- (void)complain:(NSString*)jsonData;
- (Boolean)resetGuest;
- (void)setLanguagePreference: (NSString *)jsonData;
- (NSInteger)getLanguagePreference;
- (NSString*)getLanguageCode;
- (void)redeemGiftCode:(NSString*)jsonData;
- (void)reportDouyinCustomEvent:(NSString*)eventName eventParams:(NSString*)eventParams;

@end
