#include "ComboSDKIOSInterface.h"
#include "ComboSDKIOSWrapper.h"

NSString* ConvertToNSString (const char* string)
{
    if (string)
        return [NSString stringWithUTF8String: string];
    else
        return [NSString stringWithUTF8String: ""];
}

void combo_sdk_setup(const char* jsonData)
{
    [[ComboSDKIOSWrapper shareInstance] setup:ConvertToNSString(jsonData)];
}

void combo_sdk_login()
{
    [[ComboSDKIOSWrapper shareInstance] login];
}

void combo_sdk_logout()
{
   [[ComboSDKIOSWrapper shareInstance] logout];
}

void combo_sdk_purchase(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] purchase:ConvertToNSString(jsonData)];
}

const char* combo_sdk_getUserInfo()
{
     NSString *userInfo = [[ComboSDKIOSWrapper shareInstance] getUserInfo];
     // Notes: alloc memory! (free by c#)
     return strdup([userInfo UTF8String]);
}

const char* combo_sdk_getVersion()
{
     NSString *version = [[ComboSDKIOSWrapper shareInstance] getVersion];
     // Notes: alloc memory! (free by c#)
     return strdup([version UTF8String]);
}

const char* combo_sdk_getDistro()
{
     NSString *distro = [[ComboSDKIOSWrapper shareInstance] getDistro];
     // Notes: alloc memory! (free by c#)
     return strdup([distro UTF8String]);
}

const char* combo_sdk_getDeviceId()
{
     NSString *deviceId = [[ComboSDKIOSWrapper shareInstance] getDeviceId];
     // Notes: alloc memory! (free by c#)
     return strdup([deviceId UTF8String]);
}

const char* combo_sdk_getParameters()
{
    NSString *parameters = [[ComboSDKIOSWrapper shareInstance] getParameters];
    // Notes: alloc memory! (free by c#)
    return strdup([parameters UTF8String]);
}

void combo_sdk_preloadAd(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] preloadAd:ConvertToNSString(jsonData)];
}

void combo_sdk_showAd(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] showAd:ConvertToNSString(jsonData)];
}

void combo_sdk_share(const char* type, const char* jsonData)
{
    [[ComboSDKIOSWrapper shareInstance] share:ConvertToNSString(type) jsonData:ConvertToNSString(jsonData)];
}

void combo_sdk_openAppSettings()
{
    [[ComboSDKIOSWrapper shareInstance] openAppSettings];
}

const char* combo_sdk_getUserId()
{
    NSString *uid = [[ComboSDKIOSWrapper shareInstance] getUserId];
    // Notes: alloc memory! (free by c#)
    return strdup([uid UTF8String]);
}

void combo_sdk_manageAccount()
{
    [[ComboSDKIOSWrapper shareInstance] manageAccount];
}

void combo_sdk_deleteAccount()
{
    [[ComboSDKIOSWrapper shareInstance] deleteAccount];
}

void combo_sdk_changePassword()
{
    [[ComboSDKIOSWrapper shareInstance] changePassword];
}

void combo_sdk_contactSupport()
{
    [[ComboSDKIOSWrapper shareInstance] contactSupport];
}

bool combo_sdk_isFeatureAvailable(const char* feature)
{
    return [[ComboSDKIOSWrapper shareInstance] isFeatureAvailable:ConvertToNSString(feature)];
}

void combo_sdk_openGameUrlWithController(const char* gameUrl)
{
    [[ComboSDKIOSWrapper shareInstance] openGameUrlWithController:ConvertToNSString(gameUrl)];
}

void combo_sdk_getDownloadUrl()
{
   [[ComboSDKIOSWrapper shareInstance] getDownloadUrl];
}

const int* combo_sdk_getAvailableShareTargets(int* count)
{
    NSArray *targets = [[ComboSDKIOSWrapper shareInstance] getAvailableShareTargets];
    // Notes: alloc memory! (free by c#)
    
    int length = (int)[targets count];
    int *intTargets = (int *)malloc(length * sizeof(int));
    
    for (int i = 0; i < length; i++) {
        intTargets[i] = (int)[targets[i] intValue];
    }
    *count = length;
    return intTargets;
}

void combo_sdk_openShortLink(const char* link, const char* gameData)
{
    [[ComboSDKIOSWrapper shareInstance] openShortLink:ConvertToNSString(link) gameData:ConvertToNSString(gameData)];
}

void combo_sdk_checkAnnouncements(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] checkAnnouncements:ConvertToNSString(jsonData)];
}

void combo_sdk_openAnnouncements(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] openAnnouncements:ConvertToNSString(jsonData)];
}

void combo_sdk_complain(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] complain:ConvertToNSString(jsonData)];
}

bool combo_sdk_resetGuest()
{
    return [[ComboSDKIOSWrapper shareInstance] resetGuest];
}

void combo_sdk_setLanguagePreference(const char* preference)
{
    [[ComboSDKIOSWrapper shareInstance] setLanguagePreference:ConvertToNSString(preference)];
}
const int combo_sdk_getLanguagePreference()
{
    return (int)[[ComboSDKIOSWrapper shareInstance] getLanguagePreference];
}
const char* combo_sdk_getLanguageCode()
{
    NSString *code = [[ComboSDKIOSWrapper shareInstance] getLanguageCode];
    return strdup(code.UTF8String);
}

void combo_sdk_redeemGiftCode(const char* jsonData)
{
   [[ComboSDKIOSWrapper shareInstance] redeemGiftCode:ConvertToNSString(jsonData)];
}

void combo_sdk_reportDouyinCustomEvent(const char* eventName, const char* eventParams)
{
    [[ComboSDKIOSWrapper shareInstance] reportDouyinCustomEvent:ConvertToNSString(eventName) eventParams:ConvertToNSString(eventParams)];
}