using UnityEngine;
using UnityEngine.UI;
using System;
using System.Linq;

namespace _Core
{
    public class Alert : MonoBehaviour
    {
        public Text title;
        public Text desc;

        public Text confirmTxt;
        public Text cancelTxt;

        public Action confirmCallback;
        public Action cancelCallback;


        private static Alert alert;

        private static void InstantiateAlert()
        {
            if (alert == null)
            {
                var ins = MonoBehaviour.Instantiate(Resources.Load("Prefabs/SeayooAlert")) as GameObject;
                alert = ins.GetComponent<Alert>();
            }
        }
        public static void Show(string desc, string title = "", Action confirmCallback = null,
        string confirmTxt = "", Action cancelCallback = null, string cancelTxt = "")
        {
            InstantiateAlert();
            alert.desc.text = desc;
            if(alert.desc.text.Count() >= 15)
            {
                alert.desc.alignment = TextAnchor.MiddleLeft;
            }
            else
            {
                alert.desc.alignment = TextAnchor.MiddleCenter;
            }
            alert.confirmCallback = confirmCallback;
            alert.cancelCallback = cancelCallback;
            alert.confirmTxt.text = string.IsNullOrEmpty(confirmTxt) ? I18n.T("confirm_button") : confirmTxt;
            alert.cancelTxt.text = string.IsNullOrEmpty(cancelTxt) ? I18n.T("cancel_button") : cancelTxt;
            alert.gameObject.SetActive(true);
        }

        public void OnConfirm()
        {
            confirmCallback?.Invoke();
            Destroy(alert.gameObject);
        }

        public void OnCancel()
        {
            cancelCallback?.Invoke();
            Destroy(alert.gameObject);
        }
    }
}