using _Core;

namespace _Combo
{
    public class FeatureNotAvailableError : BaseCause
    {
        public string Feature { get; set; }
        public FeatureNotAvailableError(string feature)
        {
            Feature = feature;
        }
        public override string GetMessage()
        {
            return I18n.T("feature_unavailable_error");
        }

        public override string ToString()
        {
            string result = $"FeatureNotAvailableError" +
                $"\nfeature = {Feature}";
                
            return result;
        }
    }
}