package com.seayoo.sdk;

import android.app.Application;
import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.multidex.MultiDex;

import com.seayoo.sdk.api.ComboSDK;

public class ComboSDKApplication extends Application {

    @Override
    protected void attachBaseContext(Context context) {
        super.attachBaseContext(context);
        MultiDex.install(context); // 64k方法数
        ComboSDK.getInstance().onApplicationAttachBaseContext(context);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        ComboSDK.getInstance().onApplicationCreate(this);
    }
}
