/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.logger;

import io.sentry.ISentryClient;
import io.sentry.ISentryExecutorService;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLogEvent;
import io.sentry.SentryLogEvents;
import io.sentry.SentryOptions;
import io.sentry.logger.ILoggerBatchProcessor;
import io.sentry.util.AutoClosableReentrantLock;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LoggerBatchProcessor
implements ILoggerBatchProcessor {
    public static final int FLUSH_AFTER_MS = 5000;
    public static final int MAX_BATCH_SIZE = 100;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ISentryClient client;
    @NotNull
    private final Queue<SentryLogEvent> queue;
    @NotNull
    private final ISentryExecutorService executorService;
    @Nullable
    private volatile Future<?> scheduledFlush;
    @NotNull
    private static final AutoClosableReentrantLock scheduleLock = new AutoClosableReentrantLock();
    private volatile boolean hasScheduled = false;

    public LoggerBatchProcessor(@NotNull SentryOptions options, @NotNull ISentryClient client) {
        this.options = options;
        this.client = client;
        this.queue = new ConcurrentLinkedQueue<SentryLogEvent>();
        this.executorService = new SentryExecutorService();
    }

    @Override
    public void add(@NotNull SentryLogEvent logEvent) {
        this.queue.offer(logEvent);
        this.maybeSchedule(false, false);
    }

    @Override
    public void close(boolean isRestarting) {
        if (isRestarting) {
            this.maybeSchedule(true, true);
            this.executorService.submit(() -> this.executorService.close(this.options.getShutdownTimeoutMillis()));
        } else {
            this.executorService.close(this.options.getShutdownTimeoutMillis());
            while (!this.queue.isEmpty()) {
                this.flushBatch();
            }
        }
    }

    private void maybeSchedule(boolean forceSchedule, boolean immediately) {
        if (this.hasScheduled && !forceSchedule) {
            return;
        }
        try (@NotNull ISentryLifecycleToken ignored = scheduleLock.acquire();){
            @Nullable Future<?> latestScheduledFlush = this.scheduledFlush;
            if (forceSchedule || latestScheduledFlush == null || latestScheduledFlush.isDone() || latestScheduledFlush.isCancelled()) {
                this.hasScheduled = true;
                int flushAfterMs = immediately ? 0 : 5000;
                this.scheduledFlush = this.executorService.schedule(new BatchRunnable(), flushAfterMs);
            }
        }
    }

    private void flush() {
        this.flushInternal();
        try (@NotNull ISentryLifecycleToken ignored = scheduleLock.acquire();){
            if (!this.queue.isEmpty()) {
                this.maybeSchedule(true, false);
            } else {
                this.hasScheduled = false;
            }
        }
    }

    private void flushInternal() {
        do {
            this.flushBatch();
        } while (this.queue.size() >= 100);
    }

    private void flushBatch() {
        @NotNull ArrayList<SentryLogEvent> logEvents = new ArrayList<SentryLogEvent>(100);
        do {
            SentryLogEvent logEvent;
            if ((logEvent = this.queue.poll()) == null) continue;
            logEvents.add(logEvent);
        } while (!this.queue.isEmpty() && logEvents.size() < 100);
        this.client.captureBatchedLogEvents(new SentryLogEvents(logEvents));
    }

    private class BatchRunnable
    implements Runnable {
        private BatchRunnable() {
        }

        @Override
        public void run() {
            LoggerBatchProcessor.this.flush();
        }
    }
}

