﻿using System;
using System.IO;
using UnityEngine;

namespace Combo
{
    public class Configuration : ScriptableObject
    {
        public readonly static string EndpointChina = "https://api.seayoo.com";

        [field: SerializeField]
        public string GameId { get; set; }

        [field: SerializeField]
        public string PublishableKey { get; set; }

        [field: SerializeField]
        public string Endpoint { get; set; } = EndpointChina;

        [field: SerializeField]
        public bool EnableIOSPostBuild { get; set; } = true;

        [field: SerializeField]
        public string IOSComboSDK { get; set; }

        [field: SerializeField]
        public bool EnableKeepRenderingOnPause { get; set; } = false;

        [field: SerializeField]
        public string WindowsComboSDKJsonPath { get; set; }

        internal const string ConfigRootFolder = "ComboSDK";
        internal const string ConfigName = "ComboSDKSettings";

        /// Path for the config for Unity
        /// </summary>
        public static string GetConfigPath()
            => $"Assets/{ConfigRootFolder}/Resources/{ConfigName}.asset";
        private static Configuration instance;
        public static Configuration Instance
        {
            get
            {
                if (instance == null)
                {
                    instance = Resources.Load(ConfigName) as Configuration;
                    if (instance == null)
                    {
                        throw new FileNotFoundException("The ComboSDKSettings asset was not found. Please Open Menu: ComboSDK/Wizard");
                    }
                    CheckParameters();
                }

                return instance;
            }
        }

        private static void CheckParameters()
        {
            if (string.IsNullOrEmpty(instance.GameId))
            {
                throw new ArgumentException("The Game Id of ComboSDKSettings cannot be null or empty");
            }

            if (string.IsNullOrEmpty(instance.PublishableKey))
            {
                throw new ArgumentException("The PublishableKey of ComboSDKSettings cannot be null or empty");
            }

            if (string.IsNullOrEmpty(instance.Endpoint))
            {
                throw new ArgumentException("The Endpoint of ComboSDKSettings cannot be null or empty");
            }
        }
    }
}
