using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using UnityEngine;
using UnityEngine.UI;

namespace Seayoo.ComboSDK.Windows.Account.View.Extensions
{
    public class SeayooAccountDropdownItem : MonoBehaviour
    {
        public Text txt;

        public Button deleteBtn;

        public void Awake()
        {
            deleteBtn.onClick.AddListener(OnClick);
        }

        public void Destroy()
        {
            deleteBtn.onClick.RemoveListener(OnClick);
        }

        public void OnClick()
        {
            SendMessageUpwards("ClickDropdowItem", ExtractMobileMask(txt.text));
        }

        public static string ExtractMobileMask(string text)
        {
            string pattern = @"<color=#13243D>(.*?)</color>";
            Match match = Regex.Match(text, pattern);

            if (match.Success)
            {
                return match.Groups[1].Value;
            }

            return null;
        }
    }
}
