using _Core;

namespace _Combo
{
    internal class SignInParameters
    {
        public class Request : Serializable
        {
            public string idp;
            public ServerCredential.Credential credential;
        }

        public class Response : Serializable
        {
            [Newtonsoft.Json.JsonProperty("combo_id")]
            public string comboId;
            public string idp;
            [Newtonsoft.Json.JsonProperty("external_id")]
            public string externalId;
            [Newtonsoft.Json.JsonProperty("external_name")]
            public string externalName;
            [Newtonsoft.Json.JsonProperty("identity_token")]
            public string identityToken;
            [Newtonsoft.Json.JsonProperty("expires_at")]
            public int expiresAt;
            [Newtonsoft.Json.JsonProperty("real_name_required")]
            public bool realNameRequired;
            [Newtonsoft.Json.JsonProperty("real_name_ticket")]
            public string realNameTicket;
            [Newtonsoft.Json.JsonProperty("activation_required")]
            public bool activationRequired;
            [Newtonsoft.Json.JsonProperty("activation_ticket")]
            public string activationTicket;
            [Newtonsoft.Json.JsonProperty("fangchenmi_ttl", NullValueHandling = Newtonsoft.Json.NullValueHandling.Ignore)]
            public int? fangchenmiTtl = null;
        }
    }
}
