using System;
using _Core;

namespace _Combo
{
    public class StoreError : ThirdPartyError
    {
        public Order Order { get; }
        public override string ModuleName { get; }
        public override int? ThirdPartyCode { get; }
        public override string ThirdPartyMessage { get; }
        public override Exception Cause { get; }
        public override bool EnableTracking { get ; set; }

        public StoreError(Order order, string moduleName, int? thirdPartyCode = null, string thirdPartyMessage = "", Exception cause = null, bool enableTracking = true)
        {
            Order = order;
            ModuleName = moduleName;
            ThirdPartyCode = thirdPartyCode;
            ThirdPartyMessage = thirdPartyMessage;
            Cause = cause;
            EnableTracking = enableTracking;
        }
        public override string GetMessage()
        {
            return I18n.T("iap_payment_failed");
        }

        public override string ToString()
        {
            string result = $"StoreError" +
                $"\norder = '{Order.ToJson()}'" +
                $"\nmoduleName = '{ModuleName}'";

            if (ThirdPartyCode != null)
            {
                result += $"\nthirdPartyCode = '{ThirdPartyCode}'";
            }
            if (!string.IsNullOrEmpty(ThirdPartyMessage))
            {
                result += $"\nthirdPartyMessage = '{ThirdPartyMessage}'";
            }
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }

            return result;
        }
    }
}