namespace Combo
{
    public class ComplainOptions : Serializable
    {
        /// <summary>
        /// 被举报目标类型
        /// </summary>
        public string TargetType { get; set; }

        /// <summary>
        /// 举报目标唯一标识
        /// </summary>
        public string TargetId { get; set; }

        /// <summary>
        /// 被举报目标的显示名
        /// </summary>
        public string TargetName { get; set; }

        /// <summary>
        /// 举报类型
        /// </summary>
        public string Category { get; set; }

        /// <summary>
        /// 举报者所在的游戏服务器 ID
        /// </summary>
        public string ServerId { get; set; }

        /// <summary>
        /// 举报者的游戏角色 ID
        /// </summary>
        public string RoleId { get; set; }

        /// <summary>
        /// 举报者的游戏角色名
        /// </summary>
        public string RoleName { get; set; }

        /// <summary>
        /// 游戏侧自定义的举报上下文
        /// </summary>
        public string Context { get; set; }

        /// <summary>
        /// 举报页面宽度占屏幕宽度的百分比
        /// </summary>
        public int Width { get; set; }

        /// <summary>
        /// 举报页面高度占屏幕高度的百分比
        /// </summary>
        public int Height { get; set; }
    }
}