using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System;
using _Core;
using _Combo.Events;

namespace Seayoo.ComboSDK.Windows.Account.View
{
    [Register(typeof(SeayooAccountViewMediator))]
    [RequireComponent(typeof(__RegisterMediator))]
    public class SeayooAccountView : MonoBehaviour
    {
        public event Action OnCreate;
        void Awake() {
            EventSystem.Register(this);
        }

        void Start()
        {
            OnCreate?.Invoke();
            StartCoroutine(AttachEventSystemCoroutine());
        }

        private IEnumerator AttachEventSystemCoroutine()
        {
            yield return null; // 等待一帧，确保销毁操作完成

            var eventSystem = FindObjectOfType<UnityEngine.EventSystems.EventSystem>();
            if (eventSystem == null)
            {
                Log.I("Attach EventSystem and StandaloneInputModule.");
                gameObject.AddComponent<UnityEngine.EventSystems.EventSystem>();
                gameObject.AddComponent<UnityEngine.EventSystems.StandaloneInputModule>();
            }
            else
            {
                Log.I("Existed EventSystem.");
            }
        }
        void OnDestroy()
        {
            Log.I("Bye Bye...");
            EventSystem.UnRegister(this);
        }

        [EventSystem.BindEvent]
        void OnCloseWindow(CloseWindowCommand action)
        {
            Destroy(this.gameObject);
        }

        [EventSystem.BindEvent]
        void OnCloseWindow(CloseLoginViewEvent evt)
        {
             Destroy(this.gameObject);
        }

        [EventSystem.BindEvent]
        public void OnShowView(ShowLoginViewCommand evt)
        {
            gameObject.SetActive(true);
        }

        [EventSystem.BindEvent]
        public void LoginSwitchAccount(LoginSwitchAccountEvent e)
        {
            GoToViewCommand.Invoke(new GoToViewCommand{
                viewType = SeayooAccountViewType.PHONE
            });
        }

        [EventSystem.BindEvent]
        public void DeleteUserHistory(DeleteUserHistoryEvent e)
        {
            UserHistoryManager.Instance.DeleteUserHistory(e.userId);
        }
    }
}
