using System;
using _Core;

namespace _Combo
{
    public class LoginError : ThirdPartyError
    {
        public LoginErrorType errorType = LoginErrorType.UNKNOWN_ERROR;
        public override string ModuleName { get; }
        public override int? ThirdPartyCode { get; }
        public override string ThirdPartyMessage { get; }
        public override Exception Cause { get; }
        public override bool EnableTracking { get ; set; }

        public LoginError(string moduleName, LoginErrorType errorType = LoginErrorType.UNKNOWN_ERROR, int? thirdPartyCode = null, string thirdPartyMessage = "", Exception cause = null, bool enableTracking = true)
        {
            this.errorType = errorType;
            ModuleName = moduleName;
            ThirdPartyCode = thirdPartyCode;
            ThirdPartyMessage = thirdPartyMessage;
            Cause = cause;
            EnableTracking = enableTracking;
        }

        public override string GetMessage()
        {
            return GetMessageByType(errorType, ThirdPartyCode);
        }

        public override string ToString()
        {
            string result =  $"LoginError" +
                $"\ntype = {errorType}" +
                $"\nmoduleName = '{ModuleName}'";
            
            if (ThirdPartyCode != null)
            {
                result += $"\nthirdPartyCode = '{ThirdPartyCode}'";
            }
            if (!string.IsNullOrEmpty(ThirdPartyMessage))
            {
                result += $"\nthirdPartyMessage = '{ThirdPartyMessage}'";
            }
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }

            return result;
        }

        private string GetMessageByType(LoginErrorType errorType, int? ThirdPartyCode = null)
        {
            switch (errorType) {
                case LoginErrorType.REAL_NAME_NOT_SUPPORT:
                    return I18n.T("real_name_required_error");
                case LoginErrorType.FEATURE_NOT_AVAILABLE:
                    return I18n.T("unsupported_login_method_error");
                case LoginErrorType.ACCOUNT_INVALID:
                    return I18n.T("credential_expired_error");
                default:
                    return ThirdPartyCode == null ? I18n.T("unknown_error") : $"{I18n.T("unknown_error")}({ThirdPartyCode})" ;
            }
        }
    }

    public enum LoginErrorType {
        REAL_NAME_NOT_SUPPORT,
        FEATURE_NOT_AVAILABLE,
        ACCOUNT_INVALID,
        UNKNOWN_ERROR
    }
}