using System;
using System.Collections.Generic;
using _Core;

namespace _Combo
{
    public class LocalServerError : BaseCause {
        public Exception Cause { get; set; }
        public LocalServerError(Exception cause = null)
        {
            Cause = cause;
        }
        public override string GetMessage()
        {
            if (Cause != null)
            {
                return Cause.Message ?? I18n.T("system_error");
            }
            return I18n.T("system_error");
        }

        public override bool EnableTracking {
            get { return true;}
        }

        public override string ToString()
        {
            string result = $"LocalServerError\n";
                
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }
            return result;
        }
    }
}