using System;
using System.Collections.Generic;

namespace Combo
{
    public abstract class ShareOptions : Serializable {
        /// <summary>
        /// 分享的平台
        /// </summary>
        public ShareTarget Target { get; set; }
    }

    [System.Serializable]
    public class ImageShareOptions : ShareOptions
    {
        /// <summary>
        /// 分享的标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 分享的文本内容
        /// </summary>
        public string Text { get; set; }

        /// <summary>
        /// 分享的图片地址
        /// </summary>
        public string ImageUrl { get; set; }

        /// <summary>
        /// 分享附加话题
        /// </summary>
        public string Hashtag { get; set; }

        /// <summary>
        /// 分享目标场景
        /// </summary>
        public ShareScene Scene { get; set; }
    }

    [System.Serializable]
    public class VideoShareOptions : ShareOptions
    {
        /// <summary>
        /// 分享的标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 分享的文本内容
        /// </summary>
        public string Text { get; set; }

        /// <summary>
        /// 分享的视频地址
        /// </summary>
        public string VideoUrl { get; set; }

        /// <summary>
        /// 视频封面链接
        /// </summary>
        public string VideoCoverUrl { get; set; }

        /// <summary>
        /// 分享附加话题
        /// </summary>
        public string Hashtag { get; set; }

        /// <summary>
        /// 分享目标场景
        /// </summary>
        public ShareScene Scene { get; set; }
    }

    [System.Serializable]
    public class LinkShareOptions : ShareOptions
    {
        /// <summary>
        /// 分享标题
        /// </summary>
        public string Title { get; set; }
        
        /// <summary>
        /// 分享的文本内容
        /// </summary>
        public string Text { get; set; }

        /// <summary>
        /// 分享链接
        /// </summary>
        public string LinkUrl { get; set; }

        /// <summary>
        /// 封面图链接
        /// </summary>
        public string LinkCoverUrl { get; set; }

        /// <summary>
        /// 分享目标场景
        /// </summary>
        public ShareScene Scene { get; set; }
    }
}

