using System.Collections.Generic;
using _Core;
using UnityEngine.Scripting;

[Preserve]
public class TapTapLoginResult : Serializable
{
    [Newtonsoft.Json.JsonProperty("access_token")]
    public AccessToken accessToken;

    [Newtonsoft.Json.JsonProperty("openid")]
    public string openId;

    [Newtonsoft.Json.JsonProperty("unionid")]
    public string unionId;

    [Newtonsoft.Json.JsonProperty("name")]
    public string name;

    [Newtonsoft.Json.JsonProperty("avatar")]
    public string avatar;
        
    [Newtonsoft.Json.JsonProperty("email")]
    public string email;

}
[Preserve]
public class AccessToken : Serializable
{
    [Newtonsoft.Json.JsonProperty("kid")]
    public string kid;

    [Newtonsoft.Json.JsonProperty("token_type")]
    public string tokenType;

    [Newtonsoft.Json.JsonProperty("mac_key")]
    public string macKey;

    [Newtonsoft.Json.JsonProperty("mac_algorithm")]
    public string macAlgorithm;

    [Newtonsoft.Json.JsonProperty("scope")]
    public HashSet<string> scopeSet;
}