using System;

namespace Seayoo.ComboSDK.Windows.Account
{
    [AttributeUsage(AttributeTargets.Class)]
    public class RegisterAttribute : Attribute
    {
        public Type MediatorType;
        public RegisterAttribute(Type MediatorType)
        {
            this.MediatorType = MediatorType;
        }
        public static IMediator Create(object target)
        {
            IMediator mediator = null;
            if (target == null)
                return null;
            var attributes = target.GetType().GetCustomAttributes(true);
            if (attributes != null)
            {
                foreach (Attribute attr in attributes)
                {
                    var registerAttr = attr as RegisterAttribute;
                    if (registerAttr != null)
                    {
                        mediator = Activator.CreateInstance(registerAttr.MediatorType, target) as IMediator;
                    }
                }
            }
            return mediator;
        }
    }
}
