using System;
using System.Runtime.InteropServices;
using _Combo;
using _Combo.Events;
using _Core;
using UnityEngine.Scripting;

namespace Seayoo.ComboSDK.Windows.Lenovo
{
    [Preserve]
    public class Lenovo : Singleton<Lenovo>, IdP, IStore
    {
        public Lenovo() { }

        public void Setup(SetupOptions opts)
        {
            try
            {
                Init();
                SetupSuccessEvent.Invoke(new SetupSuccessEvent()
                {
                    idp = "lenovo"
                });
            }
            catch (Exception error)
            {
                var setupError = new InitializedError(InitializedErrorType.INIT_FAILED, cause: error);
                SetupFailedEvent.Invoke(new SetupFailedEvent()
                {
                    
                    error = new InternalError(setupError)
                });
            }
        }

        public void Setup(StoreParameters storeParameters)
        {
        }

        public void OnSignIn(bool isSuccess)
        {
        }

        public void Login()
        {
            LenovoManager.Instance.Login();
        }

        public void Logout()
        {
            LenovoManager.Instance.Logout();
        }

        public void Purchase(string orderToken, Order order, PurchaseOptions purchaseOptions)
        {
            var opts = (LenovoPCPurchaseOptions)purchaseOptions;
            LenovoPurchaseRequest lenovoPurchaseRequest;
            if (opts.extraCommonParam == null)
            {
                lenovoPurchaseRequest = new LenovoPurchaseRequest
                {
                    notifyUrl = opts.notifyUrl,
                    outTradeNo = order.orderId,
                    totalFee = order.amount / 100,
                    subject = order.productName,
                };
            }
            else
            {
                lenovoPurchaseRequest = new LenovoPurchaseRequest
                {
                    notifyUrl = opts.notifyUrl,
                    outTradeNo = order.orderId,
                    totalFee = order.amount / 100,
                    subject = order.productName,
                    extraCommonParam = opts.extraCommonParam,
                };
            }

            LenovoManager.GetInstance().Purchase(order, lenovoPurchaseRequest);
        }

        public string GetStore()
        {
            return "lenovo_pc";
        }

        public bool IsFeatureAvailable(Feature feature)
        {
            return feature == Feature.PRODUCT_QUANTITY;
        }

        public void LinkIdentity(Credential credential)
        {

        }

        private void Init()
        {
            LenovoManager.Instance.Init();
        }

    }
}
