using System;
using System.Runtime.InteropServices;
using UnityEngine.Scripting;

namespace _Core
{
    [Preserve]
    public static class LGGameSDK
    {
        // 定义回调函数类型
        [UnmanagedFunctionPointer(CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public delegate bool LGSDKCallBack(IntPtr in_param);

        // 导入LGSDKInit函数
        [DllImport("PCGameSDK.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public static extern bool LGSDKInit(LGSDKCallBack callback);

        // 导入LGSDKSetPayCallback函数
        [DllImport("PCGameSDK.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public static extern bool LGSDKSetPayCallback(LGSDKCallBack callback);

        // 导入LGSDKLogin函数
        [DllImport("PCGameSDK.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public static extern int LGSDKLogin(string jsonParam);

        // 导入LGSDKPay函数
        [DllImport("PCGameSDK.dll", CallingConvention = CallingConvention.Cdecl, CharSet = CharSet.Ansi)]
        public static extern int LGSDKPay(string in_param);
    }
}