using System;
using System.Collections;
using System.Collections.Generic;
using _Combo;
using _Core;
using UnityEngine;
using UnityEngine.UI;

namespace _Combo
{
    [ViewPrefab("Prefabs/ComboToastView")]
    internal class ToastView : View<ToastView>
    {
        public Image toastImage;
        public Text toastText;

        protected override IEnumerator OnShow()
        {
            CancelInvoke();
            AdjustWidth();
            yield return null;
        }
        protected override IEnumerator OnHide()
        {
            yield return null;
        }
        public void SetText(string message) {
            toastText.text = message;
        }
        private void AdjustWidth()
        {
            var textWidth = toastText.preferredWidth;
            var imageRect = toastImage.GetComponent<RectTransform>();
            var textRect = toastText.GetComponent<RectTransform>();

            imageRect.sizeDelta = new Vector2(textWidth + 20f, imageRect.sizeDelta.y);
            textRect.sizeDelta = new Vector2(textWidth, textRect.sizeDelta.y);
        }
    }
}