using System.Collections.Generic;
using UnityEngine;
using _Combo;

namespace Seayoo.ComboSDK.Windows
{
    public class ComboSDKSetupOptions
    {
        public string gameId;
        public string publishableKey;
        public string endpoint = "https://api.dev.seayoo.com";
        public Dictionary<string, object> extra;

        public SetupOptions ToSetupOptions()
        {
            return new SetupOptions
            {
                gameId = gameId,
                publishableKey = publishableKey,
                endpoint = endpoint,
                unitySdkVersion = extra.ContainsKey("combo_sdk_unity_version") ? extra["combo_sdk_unity_version"].ToString() : "",
                unityVersion = extra.ContainsKey("unity_version") ? extra["unity_version"].ToString() : Application.unityVersion,
            };
        }
    }
}
