using System;

namespace Combo
{
    public static class ErrorCode
    {
        /// <summary>
        /// 无效的参数
        /// </summary>
        public static string InvalidArguments = "INVALID_ARGUMENTS";
        [Obsolete("该属性已弃用")]
        public static string InvalidConfiguration = "INVALID_CONFIGURATION";
        [Obsolete("该属性已弃用")]
        public static string GetParametersError = "GET_PARAMETERS_ERROR";
        /// <summary>
        /// 登录错误
        /// </summary>       
        public static string LoginError = "LOGIN_ERROR";
        /// <summary>
        /// 支付错误
        /// </summary>
        public static string StoreError = "STORE_ERROR";
        /// <summary>
        /// 错误的短链接（如短链接不存在或已经禁用)
        /// </summary>
        public static string InvalidShortLink = "INVALID_SHORT_LINK";
        /// <summary>
        /// 传入的游戏数据不正确（如缺少 shortLink 所必需的数据字段）
        /// </summary>
        public static string InvalidGameData = "INVALID_GAME_DATA";
        /// <summary>
        /// 公告页面地址不合法
        /// </summary>
        public static string InvalidAnnouncementsUrl = "INVALID_ANNOUNCEMENTS_URL";
        /// <summary>
        /// 举报页面地址不合法
        /// </summary>
        public static string InvalidComplainsUrl = "INVALID_COMPLAIN_URL";
        /// <summary>
        /// 礼包码页面地址不合法
        /// </summary>
        public static string InvalidGiftCodeUrl = "INVALID_GIFT_CODE_URL";
        /// <summary>
        /// 用户取消
        /// </summary>            
        public static string UserCancelled = "USER_CANCELLED";
        /// <summary>
        /// 网络错误
        /// </summary>
        public static string NetworkError = "NETWORK_ERROR";
        /// <summary>
        /// 服务器错误
        /// </summary>       
        public static string ServerError = "SERVER_ERROR";
        /// <summary>
        /// 第三方 SDK 错误
        /// </summary>     
        public static string thirdPartyError = "THIRD_PARTY_ERROR";
        /// <summary>
        /// 未知错误，用于兜底
        /// </summary>       
        public static string UnknownError = "UNKNOWN_ERROR";
    }
}
