#ifndef COMBO_SDK_INTERFACE_H
#define COMBO_SDK_INTERFACE_H

extern "C" void combo_sdk_setup(const char* jsonData);
extern "C" void combo_sdk_login();
extern "C" void combo_sdk_logout();
extern "C" void combo_sdk_purchase(const char* jsonData);
extern "C" const char* combo_sdk_getUserInfo();
extern "C" const char* combo_sdk_getVersion();
extern "C" const char* combo_sdk_getDistro();
extern "C" const char* combo_sdk_getDeviceId();
extern "C" const char* combo_sdk_getParameters();
extern "C" void combo_sdk_preloadAd(const char* jsonData);
extern "C" void combo_sdk_showAd(const char* jsonData);
extern "C" void combo_sdk_share(const char* type, const char* jsonData);
extern "C" void combo_sdk_openAppSettings();
extern "C" const char* combo_sdk_getUserId();
extern "C" void combo_sdk_deleteAccount();
extern "C" void combo_sdk_manageAccount();
extern "C" void combo_sdk_changePassword();
extern "C" void combo_sdk_contactSupport();
extern "C" bool combo_sdk_isFeatureAvailable(const char* feature);
extern "C" void combo_sdk_openGameUrlWithController(const char* gameUrl);
extern "C" void combo_sdk_getDownloadUrl();
extern "C" const int* combo_sdk_getAvailableShareTargets(int* count);
extern "C" void combo_sdk_openShortLink(const char* link, const char* gameData);
extern "C" void combo_sdk_checkAnnouncements(const char* jsonData);
extern "C" void combo_sdk_openAnnouncements(const char* jsonData);
extern "C" void combo_sdk_complain(const char* jsonData);
extern "C" bool combo_sdk_resetGuest();
extern "C" void combo_sdk_setLanguagePreference(const char* preference);
extern "C" const int combo_sdk_getLanguagePreference();
extern "C" const char* combo_sdk_getLanguageCode();
extern "C" void combo_sdk_redeemGiftCode(const char* jsonData);

#endif
