﻿using System;
using System.Reflection;
using System.Threading.Tasks;

namespace _Core
{
    internal static class TapTapCompliance
    {
        public static Type tapComplianceType = Assembly.Load("TapSDK.Compliance").GetType("TapSDK.Compliance.TapTapCompliance");

        public static void Startup(string userIdentifier)
        {
            if(tapComplianceType == null)
            {
                Log.W("Failed to get type TapTapCompliance");
            }
            else
            {
                MethodInfo methodWithThreeParams = tapComplianceType.GetMethod("Startup", 
                    BindingFlags.Static | BindingFlags.Public, 
                    null, 
                    new Type[] { typeof(string) }, 
                    null);
                if (methodWithThreeParams != null)
                {
                    methodWithThreeParams.Invoke(null, new object[] { userIdentifier });
                }
                else
                {
                    Log.W("Failed to get method Startup");
                }
            }
        }

        public static void RegisterComplianceCallback(Action<int, string> callback)
        {
            if(tapComplianceType == null)
            {
                Log.W("Failed to get type TapTapCompliance");
            }
            else
            {
                MethodInfo setCallbackMethod = tapComplianceType.GetMethod("RegisterComplianceCallback", 
                    BindingFlags.Public | BindingFlags.Static);
                if (setCallbackMethod != null)
                {
                    setCallbackMethod.Invoke(null, new object[] { callback });
                    Log.I("Callback set successfully");
                }
                else
                {
                    Log.E("Method RegisterComplianceCallback not found");
                }
            }
        }

        public static int GetAgeRange()
        {
            if (tapComplianceType == null)
            {
                Log.W("Failed to get type TapTapCompliance");
                return -1;
            }

            try
            {
                MethodInfo ageRangeMethod = tapComplianceType.GetMethod("GetAgeRange", BindingFlags.Static | BindingFlags.Public);

                if (ageRangeMethod == null)
                {
                    Log.E("Method GetAgeRange not found");
                    return -1;
                }
                var ageRangeValue = ageRangeMethod.Invoke(null, null);

                if (ageRangeValue is Task<int> task)
                {
                    return task.GetAwaiter().GetResult();
                }
                else if (ageRangeValue is int age)
                {
                    return age;
                }
                else
                {
                    Log.E($"Unsupported return type: {ageRangeValue?.GetType()}");
                    return -1;
                }
            }
            catch (TargetInvocationException ex)
            {
                Log.E($"Error while invoking GetAgeRange method: {ex.InnerException?.Message}");
                return -1;
            }
            catch (Exception ex)
            {
                Log.E($"Unexpected error: {ex.Message}");
                return -1;
            }
        }

        public static void Exit()
        {
            if(tapComplianceType == null)
            {
                Log.W("Failed to get type TapTapCompliance");
            }
            else
            {
                MethodInfo methodWithThreeParams = tapComplianceType.GetMethod("Exit", BindingFlags.Static | BindingFlags.Public);
                if (methodWithThreeParams != null)
                {
                    methodWithThreeParams.Invoke(null, null);
                }
                else
                {
                    Log.W("Failed to get method Exit");
                }
            }
        }
    }
}