using System.Collections.Generic;
using Newtonsoft.Json;
using _Core.Storage;
using Seayoo.ComboSDK.Windows.Account.Model;
using _Core;
using _Combo.Events;
using _Combo;

namespace Seayoo.ComboSDK.Windows.Account
{
    public class SeayooAccountManager : Singleton<SeayooAccountManager>
    {
        private SeayooAccountManager() { }
        private static SeayooAccountManager _instance;

        public static SeayooAccountManager GetInstance()
        {
            if (_instance == null)
            {
                if (_instance == null)
                {
                    _instance = new SeayooAccountManager();
                }
            }
            return _instance;
        }
        private User user;
        private const string autoLoginKey = "combosdk_seayoo_account_auto_login";

        public User GetUser()
        {
            return user;
        }

        public User GetAutoLoginUser()
        {
            var users = UserHistoryManager.Instance.GetUserHistories();
            if (users.Count == 0) return null;
            return users[0];
        }

        public void Login(User user, bool realNameRequired, Credential linkCredential = null)
        {
            this.user = user;
            UserHistoryManager.Instance.SaveUserHistory(user);
            if (!realNameRequired) {
                LoginSuccessEvent.Invoke(new LoginSuccessEvent {
                    credential = new SeayooCredential()
                    {
                        userId = user.userId,
                        token = user.token,
                        mobile = user.mobile,
                    },
                    linkCredential = linkCredential
                });
            };
        }

        public void PasswordLogin(User user, bool deviceGrantRequired, bool realNameRequired)
        {
            this.user = user;
            UserHistoryManager.Instance.SaveUserHistory(user);
            if (!realNameRequired && !deviceGrantRequired) {
                LoginSuccessEvent.Invoke(new LoginSuccessEvent {
                    credential = new SeayooCredential()
                    {
                        userId = user.userId,
                        token = user.token,
                        mobile = user.mobile,
                    }
                });
            };
        }

        public void Logout(string userId)
        {
            var users = UserHistoryManager.Instance.GetUserHistories();
            if (users.Count == 0)
            {
                Log.E("Error remove user data: " + userId);
                return;
            }
            UserHistoryManager.Instance.DeleteUserHistory(userId);
        }

        public void SetAutoLoginEnabled(bool enabled)
        {
            UserPrefs.SetBool(autoLoginKey, enabled);
        }
        public bool GetAutoLoginEnabled()
        {
            return UserPrefs.GetBool(autoLoginKey);
        }

#if UNITY_STANDALONE

        public void LoginWithToken(WebViewLandingPage page)
        {
            string context = "api/login-with-token";
            string url = $"{GlobalParameters.Instance.SeayooAccountWebsiteUrl}/{context}?user_id={GetUser().userId}&token={GetUser().token}";
            Dictionary<WebViewLandingPage, string> keyValuePairs = new Dictionary<WebViewLandingPage, string>
            {
                {WebViewLandingPage.ChangePassword, "change_password"},
                {WebViewLandingPage.DeleteAccount, "delete_account"}
            };
            if(page != WebViewLandingPage.ManageAccount)
            {
                string landingPage;
                keyValuePairs.TryGetValue(page, out landingPage);
                url += $"&landing_page={landingPage}";
            }
            UIController.Instance.ShowWebView(url, WebViewType.General, 100, 100);
        }
        
#endif
    }
}