using System;
using System.Collections.Generic;
using _Core;
using _Combo;

namespace Seayoo.ComboSDK.Windows.Account
{
    public static class Config
    {
        // server_url
        public static string endpoint;
        // game_id
        public static string gameId;

        public static bool hideEula;
        public static bool hideCloseButton;

        // user_agreement
        public static string userAgreement;
        // privacy_policy
        public static string privacyPolicy;
        public static string realNameNotice;
        public static string realNameFurtherNotice;
        // account
        public static string forgetPassword;


        public static void Init(string gameId)
        {
            Config.gameId = gameId;
            endpoint = GlobalParameters.Instance.SeayooAccountAPIEndPoint;
            hideEula = GlobalParameters.Instance.SeayooAccountHideEula;
            hideCloseButton = GlobalParameters.Instance.SeayooAccountHideCloseButton;

            userAgreement = GlobalParameters.Instance.SeayooAccountAgreementUrl;
            privacyPolicy = GlobalParameters.Instance.SeayooAccountPrivacyUrl;
            realNameNotice = "https://www.nppa.gov.cn/xxfb/tzgs/202108/t20210830_666285.html";
            realNameFurtherNotice = "https://www.nppa.gov.cn/xxfb/tzgs/201911/t20191119_666184.html";

            forgetPassword = GlobalParameters.Instance.SeayooAccountForgetPasswordUrl;
        }
    }
}
