using System;
using System.Collections;
using UnityEngine;
using UnityEngine.UI;

namespace _Combo
{
    [ViewPrefab("Prefabs/ComboLoadingView")]
    internal class LoadingView : View<LoadingView>
    {
        public GameObject loadingPanel;
        public Image loadingImage;
        public float delay;
        public float rotationSpeed = 80f;
        private float thresholdTime;
        void Update()
        {
            var currentRotation = loadingImage.rectTransform.eulerAngles.z;
            var newRotation = currentRotation - rotationSpeed * Time.deltaTime;

            loadingImage.rectTransform.rotation = Quaternion.Euler(0f, 0f, newRotation);
        }

        public void Start()
        {
            loadingPanel.SetActive(false);
        }

        public void SetThresholdTime(float thresholdTime)
        {
            this.thresholdTime = thresholdTime;
        }

        protected override IEnumerator OnHide()
        {
            yield return null;
        }

        protected override IEnumerator OnShow()
        {
            yield return new WaitForSeconds(thresholdTime);
            loadingPanel.SetActive(true);
        }
    }
}
