using System;
using System.Collections.Generic;
using _Core;

namespace _Combo
{
    public class InvalidArgumentsError : BaseCause
    {
        public string Argument { get; set; }
        public string Value { get; set; } = "";
        public InvalidArgumentsErrorType? errorType;
        public Exception Cause { get; set; }

        public override bool EnableTracking { get { return true;} }

        public InvalidArgumentsError (string argument, string value = "", InvalidArgumentsErrorType? errorType = null , Exception cause = null)
        {
            Argument = argument;
            Value = value;
            if(errorType != null)
            {
                this.errorType = (InvalidArgumentsErrorType)errorType;
            }
            else
            {
                this.errorType = null;
            }
            Cause = cause;
        }

        public override string GetMessage()
        {
            Dictionary<string, object> paramz = new Dictionary<string, object> {
                { "param", Argument}
            };
            return I18n.T("invalid_argument_error", paramz);
        }

        public override string ToString()
        {
            string result = $"InvalidArgumentsError" +
                $"\nargument = '{Argument}'";

            if (!string.IsNullOrEmpty(Value))
            {
                result += $"\nvalue = '{Value}'";
            }
            if (Cause != null)
            {
                result += $"\ncause = {Cause}";
            }

            return result;
        }
    }
    public enum InvalidArgumentsErrorType 
    {
        INVALID_SHORT_LINK,
        INVALID_GAME_DATA,
        INVALID_ANNOUNCEMENTS_URL,
        INVALID_ARGUMENTS,
        INVALID_COMPLAIN_URL,
        INVALID_GIFT_CODE_URL
    }
}